package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.CowManagerActivityExecutionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * @author wanghaojia
 * @date 2023/12/23 21:24
 */
@Service
public class CowManagerActivityExecutionAsyncService {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private CowManagerActivityExecutionService cowManagerActivityExecutionService;

    @Async
    public void queryDisplayCostFromCowManager(String type, String upDateTime, AbstractCrmUserIdentity userIdentity){
        loginUserService.refreshAuthentication(userIdentity);
        this.cowManagerActivityExecutionService.queryDisplayCostFromCowManager(type,upDateTime);
    }

}
