package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerExecutionDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerQueryActivityDto;
import com.biz.crm.mn.third.system.cow.manager.sdk.service.CowManagerService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.CowManagerActivityExecutionService;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/3/1
 */
@Slf4j
@Service
public class CowManagerActivityExecutionImpl implements CowManagerActivityExecutionService {

    @Autowired(required = false)
    private CowManagerService cowManagerService;

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Override
    public void queryDisplayCostFromCowManager(String type, String upDateTime) {
        String key = DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        if (AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_DISPLAY.equals(type)) {
            key = key + AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_DISPLAY;
        }
        List<AuditExecuteIndicatorDto> list = new ArrayList<>();
        boolean lock = false;
        try {
            lock = redisLockService.tryLock(QueryConstant.TPM_PULL_COW_MANAGER_DATA_LOCK + key, TimeUnit.HOURS, 12);
            if (!lock) {
                throw new RuntimeException("有任务正在拉取牛人管家活动信息，请稍后再试...");

            }
            log.info("执行指标-牛人管家,手动拉取活动,开始");
            CowManagerQueryActivityDto dto = new CowManagerQueryActivityDto();
            dto.setType(type);
            dto.setUpDataTime(upDateTime);
            List<CowManagerExecutionDto> disExecutionList = cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty(disExecutionList)) {
                list = (List<AuditExecuteIndicatorDto>) nebulaToolkitService.copyCollectionByBlankList(disExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
            }
            this.saveOrUpdate(list,type);
            log.info("执行指标-牛人管家,手动拉取活动,结束");


        } catch (Exception e) {
            log.info("执行指标-牛人管家,手动拉取活动,任务失败！");
            e.printStackTrace();

        } finally {
            if (lock) {
                redisLockService.unlock(QueryConstant.TPM_PULL_COW_MANAGER_DATA_LOCK + key);
            }
            if (!CollectionUtils.isEmpty(list)) {
                list.clear();
            }
            log.info("执行指标-牛人管家,手动拉取活动,任务完成！");
        }
    }

    /**
     * 每天4点牛人管理查询活动信息
     */
    @Override
    @DynamicTaskService(cornExpression = "0 0 4 * * ?", taskDesc = "每天4点牛人管家查询活动信息")
    public void autoQueryDisplayCostFromCowManager() {
        loginUserService.refreshAuthentication(null);
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        calendar.add(Calendar.DAY_OF_WEEK,-1);
        String key = DateUtil.format(curDate, DateUtil.DEFAULT_YEAR_MONTH_DAY) + AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_DISPLAY;
        String selectDate = DateUtil.format(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        List<AuditExecuteIndicatorDto> list = new ArrayList<>();
        boolean lock = false;
        try {
            lock = redisLockService.tryLock(QueryConstant.TPM_PULL_COW_MANAGER_DATA_LOCK + key, TimeUnit.HOURS, 12);
            if (!lock) {
                throw new RuntimeException("有任务正在拉取牛人管家上月活动信息，请稍后再试...");

            }
            CowManagerQueryActivityDto dto = new CowManagerQueryActivityDto();
            log.info("执行指标-牛人管家,拉取陈列活动,开始");
            //查询陈列活动
            dto.setType(AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_DISPLAY);
            dto.setUpDataTime(selectDate);
            List<CowManagerExecutionDto> disExecutionList = cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty(disExecutionList)) {
                list = (List<AuditExecuteIndicatorDto>) nebulaToolkitService.copyCollectionByBlankList(disExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
            }
            this.saveOrUpdate(list,AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_DISPLAY);
            log.info("执行指标-牛人管家,拉取陈列活动,结束");


        } catch (Exception e) {
            log.info("每月9号5点从牛人管家查询上月陈列活动和促销活动信息,任务失败！");
            e.printStackTrace();
            
        } finally {
            if (lock) {
                redisLockService.unlock(QueryConstant.TPM_PULL_COW_MANAGER_DATA_LOCK + key);
            }
            if (!CollectionUtils.isEmpty(list)) {
                list.clear();
            }
            log.info("每月9号5点从牛人管理查询上月陈列活动和促销活动信息,任务完成！");
        }
    }



    /**
     * 每月13号1点拉取牛人管家查询促销行销活动信息
     */
    @Override
    @DynamicTaskService(cornExpression = "0 0 1 13 * ?", taskDesc = "每月13号1点拉取牛人管家查询促销行销活动信息")
    public void autoQueryMarketingCostFromCowManager() {
        loginUserService.refreshAuthentication(null);
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        calendar.add(Calendar.MONTH,-1);
        String key = DateUtil.format(curDate, DateUtil.DEFAULT_YEAR_MONTH);
        List<AuditExecuteIndicatorDto> list = new ArrayList<>();
        boolean lock = false;
        try {
            lock = redisLockService.tryLock(QueryConstant.TPM_PULL_COW_MANAGER_DATA_LOCK + key, TimeUnit.HOURS, 12);
            if (!lock) {
                throw new RuntimeException("有任务正在拉取牛人管家上月活动信息，请稍后再试...");

            }
            CowManagerQueryActivityDto dto = new CowManagerQueryActivityDto();

            log.info("执行指标-牛人管家,拉取行销活动,开始");
            //查询行销活动
            dto.setType(AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_MARKETING);
            List<CowManagerExecutionDto> marExecutionList = cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty(marExecutionList)) {
                list = (List<AuditExecuteIndicatorDto>) nebulaToolkitService.copyCollectionByBlankList(marExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
            }
            this.saveOrUpdate(list,AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_MARKETING);
            log.info("执行指标-牛人管家,拉取行销活动,结束");

            log.info("执行指标-牛人管家,拉取促销活动,开始");
            //查询促销活动
            dto.setType(AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_PROMOTION);
            List<CowManagerExecutionDto> proExecutionList = cowManagerService.queryActivityExecution(dto);
            if (!CollectionUtils.isEmpty(proExecutionList)) {
                list = (List<AuditExecuteIndicatorDto>) nebulaToolkitService.copyCollectionByBlankList(proExecutionList, CowManagerExecutionDto.class, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
            }
            this.saveOrUpdate(list,AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_PROMOTION);
            log.info("执行指标-牛人管家,拉取促销活动,结束");

        } catch (Exception e) {
            log.info("每月13号1点从牛人管家查询上月陈列活动和促销活动信息,任务失败！");
            e.printStackTrace();

        } finally {
            if (lock) {
                redisLockService.unlock(QueryConstant.TPM_PULL_COW_MANAGER_DATA_LOCK + key);
            }
            if (!CollectionUtils.isEmpty(list)) {
                list.clear();
            }
            log.info("每月13号1点从牛人管理查询上月陈列活动和促销活动信息,任务完成！");
        }
    }


    /**
     * 批量新增/更新
     *
     * @param indicatorDtoList
     */
    private void saveOrUpdate(List<AuditExecuteIndicatorDto> indicatorDtoList,String type) {
        if (CollectionUtils.isEmpty(indicatorDtoList)) {
            return;
        }

        //分批处理
        int partialLimit = QueryConstant.ONCE_SAVE_MAX;
        int size = indicatorDtoList.size();
        if (partialLimit < size) {
            int start = 0;
            for (; size > 0; ) {
                if (size < partialLimit) {
                    partialLimit = size;
                }
                List<AuditExecuteIndicatorDto> partList = indicatorDtoList.subList(start, partialLimit);
                size -= partialLimit;
                this.bulkSave(partList,type);
                partList.clear();
            }
        }else {
            this.bulkSave(indicatorDtoList,type);
        }
        

    }

    /**
     * 分批保存
     * @param partList
     */
    private void bulkSave(List<AuditExecuteIndicatorDto> partList,String type){
        if (CollectionUtils.isEmpty(partList)) {
            return;
        }
        if (partList.size() > QueryConstant.ONCE_SAVE_MAX) {
            throw new IllegalArgumentException("牛人管家保存时，单次保存更新总数不能超过:"+QueryConstant.ONCE_SAVE_MAX);
        }
        List<String> itemCodes = partList.stream().map(AuditExecuteIndicatorDto::getActiveNumber).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        List<AuditExecuteIndicatorDto> list = new ArrayList<>();
        //更据明细编码查询是否已存在
        List<AuditExecuteIndicatorVo> indicatorVos = auditExecuteIndicatorService.findByActiveNumber(itemCodes, AuditExecuteIndicatorConstant.COW_MANAGER, BusinessUnitEnum.VERTICAL.getCode());
        //查询活动明细详情，区分是细案/差异追踪
        ArrayList<String> detailItemCodes = new ArrayList<>();
        ArrayList<String> diffTrackDetailCodes = new ArrayList<>();
        for (String itemCode : itemCodes) {
            if (itemCode.startsWith(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE)) {
                detailItemCodes.add(itemCode);
            } else if(itemCode.startsWith(AuditFeeConstants.AUDIT_FEE_DIFF_TRACK_DETAIL_CODE)) {
                diffTrackDetailCodes.add(itemCode);
            }
        }
        List<ActivityDetailPlanItemVo> detailItemVos = activityDetailPlanItemSdkService.findByItemCodes(detailItemCodes);
        List<AuditFeeDiffTrackDetailVo> diffTrackDetailVos = auditFeeDiffTrackDetailVoService.findByDetailCodes(detailItemCodes);

        log.info("同步牛人管家数据,partList:{}",partList.size());
        partList.forEach(exeDto -> {
            if (StringUtils.isNotBlank(exeDto.getActiveNumber())) {

                List<AuditExecuteIndicatorVo> items = indicatorVos.stream().filter(k -> k.getActiveNumber().equals(exeDto.getActiveNumber())).collect(Collectors.toList());

                if (!CollectionUtils.isEmpty(items)) {
                    //更新
                    if (!CollectionUtils.isEmpty(detailItemVos)) {
                        ActivityDetailPlanItemVo detailPlanItem = detailItemVos.stream().filter(v -> items.get(0).getActiveNumber().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                        List<AuditExecuteIndicatorDto> updateDtoList = this.buildInfo(exeDto, items, detailPlanItem,type);
                        log.info("同步牛人管家数据,updateList:{}",updateDtoList.size());
                        if (!CollectionUtils.isEmpty(updateDtoList)) {
                            list.addAll(updateDtoList);
                        }
                    }
                    if (!CollectionUtils.isEmpty(diffTrackDetailVos)) {
                        AuditFeeDiffTrackDetailVo trackDetailVo = diffTrackDetailVos.stream().filter(v -> items.get(0).getActiveNumber().equals(v.getDetailCode())).findFirst().orElse(null);
                        List<AuditExecuteIndicatorDto> updateDtoList = this.buildInfo(exeDto, items, trackDetailVo,type);
                        if (!CollectionUtils.isEmpty(updateDtoList)) {
                            list.addAll(updateDtoList);
                        }
                    }

                } else {
                    //新增
                    if (!CollectionUtils.isEmpty(detailItemVos)) {
                        ActivityDetailPlanItemVo detailPlanItem = detailItemVos.stream().filter(v -> exeDto.getActiveNumber().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                        List<AuditExecuteIndicatorDto> createList = this.buildInfo(exeDto, items, detailPlanItem,type);
                        log.info("同步牛人管家数据,createList:{}",createList.size());
                        if (!CollectionUtils.isEmpty(createList)) {
                            list.addAll(createList);
                        }
                    }
                    if (!CollectionUtils.isEmpty(diffTrackDetailVos)) {
                        AuditFeeDiffTrackDetailVo trackDetailVo = diffTrackDetailVos.stream().filter(v -> exeDto.getActiveNumber().equals(v.getDetailCode())).findFirst().orElse(null);
                        List<AuditExecuteIndicatorDto> createList = this.buildInfo(exeDto, items, trackDetailVo,type);
                        if (!CollectionUtils.isEmpty(createList)) {
                            list.addAll(createList);
                        }
                    }
                }
            }
        });

        auditExecuteIndicatorService.bulkImportSave(list);
    }

    /**
     * 填充数据
     *
     * @param exeDto         接口返回信息
     * @param items           已有数据对象
     * @param detailPlanItem 活动细案明细详情对象
     * @return
     */
    private List<AuditExecuteIndicatorDto> buildInfo(AuditExecuteIndicatorDto exeDto, List<AuditExecuteIndicatorVo> items, ActivityDetailPlanItemVo detailPlanItem,String type) {
        if (ObjectUtils.isEmpty(exeDto) || ObjectUtils.isEmpty(detailPlanItem)) {
            return Lists.newArrayList();
        }
        List<AuditExecuteIndicatorDto> resultList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(items)) {
            for(AuditExecuteIndicatorVo item : items) {
                item.setDockingSystem(AuditExecuteIndicatorConstant.COW_MANAGER);
                item.setIsQualifiedCode(exeDto.getIsQualifiedCode());
                item.setIsQualified(exeDto.getIsQualified());
                item.setIsQualifiedReason(exeDto.getIsQualifiedReason());
                item.setActivityStatusCode(exeDto.getActivityStatusCode());
                item.setActivityStatus(exeDto.getActivityStatus());
                item.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
                item.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
                item.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
                item.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
                item.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
                item.setSalesRegionName(detailPlanItem.getSalesRegionName());
                item.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
                item.setSalesOrgName(detailPlanItem.getSalesOrgName());
                item.setChannelCode(detailPlanItem.getDistributionChannelCode());
                item.setChannelName(detailPlanItem.getDistributionChannelName());
                item.setCustomerCode(detailPlanItem.getCustomerCode());
                item.setCustomerName(detailPlanItem.getCustomerName());
                item.setStoresCode(detailPlanItem.getTerminalCode());
                item.setStoresName(detailPlanItem.getTerminalName());
                item.setPersonnelType(detailPlanItem.getPersonType());
                item.setPersonnelId(detailPlanItem.getPersonCode());
                item.setYearAndMonth(detailPlanItem.getFeeYearMonth());
                try {
                    item.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityBeginDate()));
                    item.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityEndDate()));
                } catch (Exception e) {
                    log.error("", e);
                }
                item.setProductBrandCode(detailPlanItem.getProductBrandCode());
                item.setProductBrandName(detailPlanItem.getProductBrandName());
                item.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
                item.setProductCategoryName(detailPlanItem.getProductCategoryName());
                item.setProductItemCode(detailPlanItem.getProductItemCode());
                item.setProductItemName(detailPlanItem.getProductItemName());
                item.setProductCode(detailPlanItem.getProductCode());
                item.setProductName(detailPlanItem.getProductName());
                item.setActivityFormCode(detailPlanItem.getActivityFormCode());
                item.setActivityFormName(detailPlanItem.getActivityFormName());
                item.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
                item.setActivityTypeName(detailPlanItem.getActivityTypeName());
                item.setUpDataTime(exeDto.getUpDataTime());
                try {
                    if (IndicatorNameEnum.DEDUCTION_AMOUN.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank(exeDto.getDeductionExpenses())) {
                            item.setIndicatorValue(new BigDecimal(exeDto.getDeductionExpenses().trim()));
                        }else {
                            item.setInspectCosts(BigDecimal.ZERO);
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                        if (!StringUtils.isBlank(exeDto.getRegionInspectCost())) {
                            item.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                        }else {
                            item.setRegionInspectCosts(BigDecimal.ZERO);
                        }
                    }
                    if (IndicatorNameEnum.DEDUCTION_QUANTITY.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank(exeDto.getDeductionQuantity())) {
                            item.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                        }else {
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                    }

                    AuditExecuteIndicatorDto auditExecuteIndicatorDto = nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
                    resultList.add(auditExecuteIndicatorDto);
                } catch (Exception e) {
                    throw new RuntimeException("扣减活动金额 [" + exeDto.getInspectCost() + "] 或 扣减大区金额 [" + exeDto.getRegionInspectCost() + "] 格式错误");
                }
            }

        } else {
            exeDto.setDockingSystem(AuditExecuteIndicatorConstant.COW_MANAGER);
            exeDto.setYearAndMonth(detailPlanItem.getFeeYearMonth());
            exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
            exeDto.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
            exeDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
            exeDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
            exeDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
            exeDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
            exeDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
            exeDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
            exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
            exeDto.setChannelName(detailPlanItem.getDistributionChannelName());
            exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
            exeDto.setCustomerName(detailPlanItem.getCustomerName());
            exeDto.setStoresCode(detailPlanItem.getTerminalCode());
            exeDto.setStoresName(detailPlanItem.getTerminalName());
            exeDto.setPersonnelType(detailPlanItem.getPersonType());
            exeDto.setPersonnelId(detailPlanItem.getPersonCode());
            try {
                exeDto.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityBeginDate()));
                exeDto.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityEndDate()));
            } catch (Exception e) {
                log.error("", e);
            }
            exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
            exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
            exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
            exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
            exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
            exeDto.setProductItemName(detailPlanItem.getProductItemName());
            exeDto.setProductCode(detailPlanItem.getProductCode());
            exeDto.setProductName(detailPlanItem.getProductName());
            exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
            exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
            exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
            if (AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_DISPLAY.equals(type)) {
                //扣减数量
                AuditExecuteIndicatorDto auditExecuteIndicatorDto = nebulaToolkitService.copyObjectByWhiteList(exeDto, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
                auditExecuteIndicatorDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_QUANTITY.getCode());
                try {
                    if (!StringUtils.isBlank(auditExecuteIndicatorDto.getDeductionQuantity())) {
                        auditExecuteIndicatorDto.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                    }

                } catch (Exception e) {
                    throw new RuntimeException("扣减数量 [" + exeDto.getDeductionQuantity() + "]格式错误");
                }
                resultList.add(auditExecuteIndicatorDto);
            }

            exeDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_AMOUN.getCode());
            try {
                if (!StringUtils.isBlank(exeDto.getDeductionExpenses())) {
                    exeDto.setIndicatorValue(new BigDecimal(exeDto.getDeductionExpenses().trim()));
                }
                if (!StringUtils.isBlank(exeDto.getRegionInspectCost())) {
                    exeDto.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                }
                resultList.add(exeDto);
            } catch (Exception e) {
                throw new RuntimeException("扣减活动金额 [" + exeDto.getInspectCost() + "] 或 扣减大区金额 [" + exeDto.getRegionInspectCost() + "] 格式错误");
            }
        }
        return resultList;
    }

    /**
     * 填充数据
     *
     * @param exeDto         接口返回信息
     * @param items           已有数据对象
     * @param detailPlanItem 活动细案明细详情对象
     * @return
     */
    private List<AuditExecuteIndicatorDto> buildInfo(AuditExecuteIndicatorDto exeDto, List<AuditExecuteIndicatorVo> items, AuditFeeDiffTrackDetailVo detailPlanItem,String type) {
        if (ObjectUtils.isEmpty(exeDto) || ObjectUtils.isEmpty(detailPlanItem)) {
            return null;
        }
        List<AuditExecuteIndicatorDto> resultList = new ArrayList<>();
        if (CollectionUtils.isEmpty(items)) {
            for(AuditExecuteIndicatorVo item : items) {
                item.setDockingSystem(AuditExecuteIndicatorConstant.COW_MANAGER);
                item.setIsQualifiedCode(exeDto.getIsQualifiedCode());
                item.setIsQualified(exeDto.getIsQualified());
                item.setIsQualifiedReason(exeDto.getIsQualifiedReason());
                item.setActivityStatusCode(exeDto.getActivityStatusCode());
                item.setActivityStatus(exeDto.getActivityStatus());
                item.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
                item.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
                item.setSalesInstitutionErpCode(detailPlanItem.getSalesInstitutionErpCode());
//            item.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
//            item.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
//            item.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
//            item.setSalesRegionName(detailPlanItem.getSalesRegionName());
//            item.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
//            item.setSalesOrgName(detailPlanItem.getSalesOrgName());
                item.setChannelCode(detailPlanItem.getDistributionChannelCode());
//            item.setChannelName(detailPlanItem.getDistributionChannelName());
                item.setCustomerCode(detailPlanItem.getCustomerCode());
                item.setCustomerName(detailPlanItem.getCustomerName());
                item.setStoresCode(detailPlanItem.getTerminalCode());
                item.setStoresName(detailPlanItem.getTerminalName());
//            item.setPersonnelType(detailPlanItem.getPersonType());
                item.setPersonnelId(detailPlanItem.getPersonIdCard());
                item.setYearAndMonth(detailPlanItem.getFeeYearMonth());
                try {
                    item.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityBeginDate()));
                    item.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityEndDate()));
                } catch (Exception e) {
                    log.error("", e);
                }
                item.setProductBrandCode(detailPlanItem.getProductBrandCode());
                item.setProductBrandName(detailPlanItem.getProductBrandName());
                item.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
                item.setProductCategoryName(detailPlanItem.getProductCategoryName());
                item.setProductItemCode(detailPlanItem.getProductItemCode());
                item.setProductItemName(detailPlanItem.getProductItemName());
                item.setProductCode(detailPlanItem.getProductCode());
                item.setProductName(detailPlanItem.getProductName());
                item.setActivityFormCode(detailPlanItem.getActivityFormCode());
                item.setActivityFormName(detailPlanItem.getActivityFormName());
                item.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
                item.setActivityTypeName(detailPlanItem.getActivityTypeName());
                try {
                    if (IndicatorNameEnum.DEDUCTION_AMOUN.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank(exeDto.getInspectCost())) {
                            item.setInspectCosts(new BigDecimal(exeDto.getInspectCost().trim()));
                            item.setIndicatorValue(item.getInspectCosts());
                        }else {
                            item.setInspectCosts(BigDecimal.ZERO);
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                        if (!StringUtils.isBlank(exeDto.getRegionInspectCost())) {
                            item.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                        }else {
                            item.setRegionInspectCosts(BigDecimal.ZERO);
                        }
                    }
                    if (IndicatorNameEnum.DEDUCTION_QUANTITY.getCode().equals(item.getIndicatorName())) {
                        if (!StringUtils.isBlank(exeDto.getDeductionQuantity())) {
                            item.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                        }else {
                            item.setIndicatorValue(BigDecimal.ZERO);
                        }
                    }


                    AuditExecuteIndicatorDto auditExecuteIndicatorDto = nebulaToolkitService.copyObjectByWhiteList(item, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
                    resultList.add(auditExecuteIndicatorDto);
                } catch (Exception e) {
                    throw new RuntimeException("扣减活动金额 [" + exeDto.getInspectCost() + "] 或 扣减大区金额 [" + exeDto.getRegionInspectCost() + "] 或 扣减数量 [" + exeDto.getDeductionQuantity() + "]格式错误");
                }
            }

        } else {

            exeDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_AMOUN.getCode());
            exeDto.setDockingSystem(AuditExecuteIndicatorConstant.COW_MANAGER);
            exeDto.setYearAndMonth(detailPlanItem.getFeeYearMonth());
            exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
            exeDto.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
//            exeDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
//            exeDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
            exeDto.setSalesInstitutionErpCode(detailPlanItem.getSalesInstitutionErpCode());
//            exeDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
//            exeDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
//            exeDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
//            exeDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
            exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
//            exeDto.setChannelName(detailPlanItem.getDistributionChannelName());
            exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
            exeDto.setCustomerName(detailPlanItem.getCustomerName());
            exeDto.setStoresCode(detailPlanItem.getTerminalCode());
            exeDto.setStoresName(detailPlanItem.getTerminalName());
//            exeDto.setPersonnelType(detailPlanItem.getPersonType());
            exeDto.setPersonnelId(detailPlanItem.getPersonIdCard());
            try {
                exeDto.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityBeginDate()));
                exeDto.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityEndDate()));
            } catch (Exception e) {
                log.error("", e);
            }
            exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
            exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
            exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
            exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
            exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
            exeDto.setProductItemName(detailPlanItem.getProductItemName());
            exeDto.setProductCode(detailPlanItem.getProductCode());
            exeDto.setProductName(detailPlanItem.getProductName());
            exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
            exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
            exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
           if (AuditExecuteIndicatorConstant.COW_MANAGER_ACTIVITY_TYPE_DISPLAY.equals(type)) {
               //扣减数量
               AuditExecuteIndicatorDto auditExecuteIndicatorDto = nebulaToolkitService.copyObjectByWhiteList(exeDto, AuditExecuteIndicatorDto.class, HashSet.class, ArrayList.class);
               auditExecuteIndicatorDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_QUANTITY.getCode());
               try {
                   if (!StringUtils.isBlank(auditExecuteIndicatorDto.getDeductionQuantity())) {
                       exeDto.setIndicatorValue(new BigDecimal(exeDto.getDeductionQuantity().trim()));
                   }

               } catch (Exception e) {
                   throw new RuntimeException("扣减数量 [" + exeDto.getDeductionQuantity() + "]格式错误");
               }
               resultList.add(auditExecuteIndicatorDto);
           }

            exeDto.setIndicatorName(IndicatorNameEnum.DEDUCTION_AMOUN.getCode());
            try {
                if (!StringUtils.isBlank(exeDto.getInspectCost())) {
                    exeDto.setInspectCosts(new BigDecimal(exeDto.getInspectCost().trim()));
                    exeDto.setIndicatorValue(exeDto.getInspectCosts());
                }
                if (!StringUtils.isBlank(exeDto.getRegionInspectCost())) {
                    exeDto.setRegionInspectCosts(new BigDecimal(exeDto.getRegionInspectCost().trim()));
                }

            } catch (Exception e) {
                throw new RuntimeException("扣减活动金额 [" + exeDto.getInspectCost() + "] 或 扣减大区金额 [" + exeDto.getRegionInspectCost() + "] 格式错误");
            }
            resultList.add(exeDto);
        }
        return resultList;
    }
}
