package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.third.system.cow.personnel.center.sdk.dto.ShoppingGuideSalaryDto;
import com.biz.crm.tpm.business.variable.local.executeIndicator.entity.AuditExecuteIndicator;
import com.biz.crm.tpm.business.variable.local.executeIndicator.repository.AuditExecuteIndicatorRepository;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.CowPersonnelExecutionService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author: yaoyongming
 * @date: 2023/4/13 14:53
 */
@Slf4j
@Service
public class CowPersonnelExecutionServiceImpl implements CowPersonnelExecutionService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditExecuteIndicatorRepository auditExecuteIndicatorRepository;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void shoppingGuideSalary(List<ShoppingGuideSalaryDto> dtoList) {
        List<AuditExecuteIndicatorDto> auditExecuteIndicatorDtoList = new ArrayList<>();
        for (ShoppingGuideSalaryDto dto : dtoList) {
            Validate.notBlank(dto.getPeopleCode(), "人员编码，不能为空！");
            Validate.notBlank(dto.getSalaryYearAndMonth(), "工资年月，不能为空！");

            AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
            indicatorDto.setBusinessFormatCode(QueryConstant.CW);
            indicatorDto.setBusinessUnitCode(QueryConstant.ZKCZ);
            indicatorDto.setDockingSystem(QueryConstant.NRS);
            indicatorDto.setIndicatorName(QueryConstant.RYXZ);
            indicatorDto.setPersonCode(dto.getPeopleCode());
            indicatorDto.setPersonName(dto.getPeopleName());
            indicatorDto.setPersonIdCard(dto.getIdNumber());
            indicatorDto.setEmployeeTypeCode(dto.getStaffTypeCode());
            indicatorDto.setEmployeeTypeName(dto.getStaffTypeName());
            indicatorDto.setStoresCode(dto.getManageStoreCode());
            indicatorDto.setStoresName(dto.getManageStoreName());
            indicatorDto.setRegionCode(dto.getRegionCode());
            indicatorDto.setRegionName(dto.getRegionName());
            indicatorDto.setCustomerRetailerCode(dto.getShopkeeperCode());
            indicatorDto.setCustomerRetailerName(dto.getShopkeeperName());
            indicatorDto.setYearAndMonthStr(dto.getSalaryYearAndMonth() + "-01");
            indicatorDto.setYearAndMonth(DateUtil.parse(indicatorDto.getYearAndMonthStr(), "yyyy-MM-dd"));
            indicatorDto.setIndicatorValue(Optional.ofNullable(dto.getCompanyShouldPayTotalAmount()).orElse(BigDecimal.ZERO));

            //设置基础信息
            indicatorDto.setTenantCode(TenantUtils.getTenantCode());
            indicatorDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            indicatorDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

            AuditExecuteIndicator entity = auditExecuteIndicatorRepository.findByPeopleMonth(indicatorDto);
            if (entity != null) {
                indicatorDto.setId(entity.getId());
            }

            auditExecuteIndicatorDtoList.add(indicatorDto);
        }

        Collection<AuditExecuteIndicator> entities = nebulaToolkitService.copyCollectionByWhiteList(auditExecuteIndicatorDtoList, AuditExecuteIndicatorDto.class, AuditExecuteIndicator.class, HashSet.class, ArrayList.class);
        auditExecuteIndicatorRepository.saveOrUpdateBatch(entities);
    }
}
