package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.local.executeIndicator.repository.AuditExecuteIndicatorRepository;
import com.biz.crm.tpm.business.variable.local.executeIndicator.service.ForeignAuditExecuteIndicatorApiAsyncService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 外部系统调用处理执行指标表接口
 * @author wanghaojia
 * @date 2024/1/26 14:26
 */
@Slf4j
@Service
public class ForeignAuditExecuteIndicatorApiAsyncServiceImpl implements ForeignAuditExecuteIndicatorApiAsyncService {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private AuditExecuteIndicatorRepository auditExecuteIndicatorRepository;

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Override
    public void createFromActivityDetailPlan(List<AuditExecuteIndicatorDto> list) {
        if (CollectionUtils.isEmpty(list)){
            throw new RuntimeException("无数据上传");
        }
        list.forEach(item -> {
            Validate.notBlank(item.getActiveNumber(), "活动细案明细编码不能为空!");
            Validate.notBlank(item.getDockingSystem(), "对接系统不能为空!");
            Validate.notBlank(item.getVariableCode(), "执行指标变量编码不能为空!");
            Validate.notBlank(item.getIndicatorName(), "执行指标名称不能为空!");
            Validate.notNull(item.getIndicatorValue(), "执行指标值不能为空!");
        });
        List<String> itemCodeList = list.stream().map(AuditExecuteIndicatorDto::getActiveNumber).collect(Collectors.toList());
        //其他字段赋值
        List<ActivityDetailPlanItemVo> itemVoList = activityDetailPlanItemSdkService.findByItemCodes(itemCodeList);
        Map<String, ActivityDetailPlanItemVo> planItemVoMap = itemVoList.stream().collect(Collectors.toMap(ActivityDetailPlanItemVo::getDetailPlanItemCode, Function.identity()));
        for (AuditExecuteIndicatorDto auditExecuteIndicatorDto : list) {
            filledOtherValues(auditExecuteIndicatorDto,planItemVoMap.get(auditExecuteIndicatorDto.getActiveNumber()));
        }
        Map<String, List<AuditExecuteIndicatorDto>> groupMap = list.stream().collect(Collectors.groupingBy(item -> item.getBusinessUnitCode() + item.getVariableCode()));
        for (Map.Entry<String, List<AuditExecuteIndicatorDto>> entry : groupMap.entrySet()) {
            saveOrUpdateAuditExecuteIndicator(entry.getValue());
        }
    }

    private void saveOrUpdateAuditExecuteIndicator(List<AuditExecuteIndicatorDto> list){
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        AuditExecuteIndicatorDto firstDto = list.get(0);
        List<String> verticalItemCodes = list.stream().map(AuditExecuteIndicatorDto::getActiveNumber).collect(Collectors.toList());
        List<AuditExecuteIndicatorVo> indicatorVos = auditExecuteIndicatorService.findByActiveNumber(verticalItemCodes, firstDto.getVariableCode(),firstDto.getBusinessUnitCode());
        Map<String, AuditExecuteIndicatorVo> existsMap = indicatorVos.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, Function.identity(), (o, n) -> n));
        Date curDate = new Date();
        for (AuditExecuteIndicatorVo indicatorVo : indicatorVos) {
            indicatorVo.setYearAndMonth(curDate);
            if (existsMap.containsKey(indicatorVo.getActiveNumber())){
                indicatorVo.setId(existsMap.get(indicatorVo.getActiveNumber()).getId());
            }
        }
        auditExecuteIndicatorService.bulkImportSave(list);
    }


    /**
     * 填充其他属性
     *
     * @param exeDto     指标对象
     * @param detailPlanItem    活动细案明细
     */
    private void filledOtherValues(AuditExecuteIndicatorDto exeDto, ActivityDetailPlanItemVo detailPlanItem) {
        if (ObjectUtils.isNotEmpty(detailPlanItem)) {
            if (!ObjectUtils.isEmpty(exeDto)) {
                exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
                exeDto.setBusinessUnitCode(detailPlanItem.getBusinessUnitCode());
                exeDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
                exeDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
                exeDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
                exeDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
                exeDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
                exeDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
                exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
                exeDto.setChannelName(detailPlanItem.getDistributionChannelName());
                exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
                exeDto.setCustomerName(detailPlanItem.getCustomerName());
                exeDto.setStoresCode(detailPlanItem.getTerminalCode());
                exeDto.setStoresName(detailPlanItem.getTerminalName());
                exeDto.setPersonnelType(detailPlanItem.getPersonType());
                exeDto.setPersonnelId(detailPlanItem.getPersonCode());
                try {
                    exeDto.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityBeginDate()));
                    exeDto.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityEndDate()));
                } catch (Exception e) {
                    log.error("", e);
                }
                exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
                exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
                exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
                exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
                exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
                exeDto.setProductItemName(detailPlanItem.getProductItemName());
                exeDto.setProductCode(detailPlanItem.getProductCode());
                exeDto.setProductName(detailPlanItem.getProductName());
                exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
                exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
                exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
                exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
            }

        }
    }


}
