package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.PromotionActivityCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PromotionActivityCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.QueryActivitySapCallbackService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.SapInterfaceEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.constant.SubComActivityDesignConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorLogEventDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.log.AuditExecuteIndicatorEventListener;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Description: SAP执行结果回调
 * @Author qiancheng
 * @Date 2023/2/14
 */
@Slf4j
@Service
public class QueryActivitySapCallbackServiceImpl implements QueryActivitySapCallbackService {

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    /**
     * SAP促销活动执行结果-分公司回调
     * @param dto
     */
    @Override
    public void queryBranchCallback(PromotionActivityCallbackDto dto) {
        List<String> lockKey = new ArrayList<>();
        try {

            if(org.springframework.util.ObjectUtils.isEmpty(dto)){
                return;
            }
            List<PromotionActivityCallbackDataDto> item1 = dto.getITEM1();
            if(CollectionUtils.isEmpty(item1)){
                return;
            }
            Iterator<PromotionActivityCallbackDataDto> it = item1.iterator();
            while (it.hasNext()) {
                PromotionActivityCallbackDataDto next = it.next();

                if (StringUtils.isNotBlank(next.getZFHDITEM())) {

                    boolean locked = redisLockService.tryLock(QueryConstant.TPM_SAVE_SAP_EXECUTE_INDICATOR_LOCK + next.getZFHDITEM(), TimeUnit.HOURS, 1);
                    if (locked) {
                        lockKey.add(next.getZFHDITEM());
                    }else {
                        it.remove();
                    }
                }
            }

            this.generateSapExecuteIndicatorData(item1);
        } catch (Exception e) {
            log.error("执行指标管理,SAP执行结果保存失败,信息头:{}", JSON.toJSONString(dto.getMessageHeader()));
            e.printStackTrace();
            throw new RuntimeException("数据处理失败");
        }  finally {
            if (!CollectionUtils.isEmpty(lockKey)) {
                redisLockService.batchUnLock(QueryConstant.TPM_SAVE_SAP_EXECUTE_INDICATOR_LOCK,lockKey);
            }

            //执行指标表数据同步完毕，通知分子活动规划1个小时后处理事中活动预算回退
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(DateUtil.getDateStrByFormat(new Date(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
            mqMessageVo.setTopic(SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(SubComActivityDesignConstant.TPM_SUB_COM_ACTIVITY_DESIGN_UPDATE_CLOSE_AMOUNT_TAG);
            rocketMqProducer.sendMqMsg(mqMessageVo, 3*60);
        }

    }

    private void generateSapExecuteIndicatorData(List<PromotionActivityCallbackDataDto> item1) {
        if (CollectionUtils.isEmpty(item1)) {
            return;
        }
        //属于活动细案的回调信息集合
        List<PromotionActivityCallbackDataDto> verticalExeDtoList = item1.stream()
                .filter(k -> StringUtils.isNotBlank(k.getZFCXHD()) && k.getZFCXHD().startsWith(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE))
                .collect(Collectors.toList());
        //属于分子活动细案的回调信息集合
        List<PromotionActivityCallbackDataDto> subComExeDtoList = item1.stream()
                .filter(k -> StringUtils.isNotBlank(k.getZFHDITEM()) && k.getZFHDITEM().startsWith(SubComActivityDetailPlanConstant.ACTIVITY_CONST_DETAIL_PLAN_PROMOTION_NO))
                .collect(Collectors.toList());
        //活动细案明细编码
        List<String> verticalItemCodes = verticalExeDtoList.stream().map(PromotionActivityCallbackDataDto::getZFCXHD).filter(Objects::nonNull).collect(Collectors.toList());
        //分子活动细案明细编码
        List<String> subComItemCodes = subComExeDtoList.stream().map(PromotionActivityCallbackDataDto::getZFHDITEM).filter(Objects::nonNull).collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(verticalItemCodes)) {

            //根据 明细编码+来源系统+业务单元 查询已有数据
            String businessUnitCode = BusinessUnitEnum.VERTICAL.getCode();
            List<AuditExecuteIndicatorVo> indicatorVos = auditExecuteIndicatorService.findByActiveNumber(verticalItemCodes,AuditExecuteIndicatorConstant.SAP,businessUnitCode);
            //保存/更新数据
            buildInfo(businessUnitCode,verticalExeDtoList,indicatorVos,verticalItemCodes);
        }
        if (!CollectionUtils.isEmpty(subComItemCodes)) {

            //根据 明细编码+来源系统+业务单元 查询已有数据
            String businessUnitCode = BusinessUnitEnum.SON_COMPANY.getCode();
            List<AuditExecuteIndicatorVo> indicatorVos = auditExecuteIndicatorService.findByActiveNumber(subComItemCodes,AuditExecuteIndicatorConstant.SAP,businessUnitCode);

            //保存/更新数据
            buildInfo(businessUnitCode,subComExeDtoList,indicatorVos,subComItemCodes);
        }
    }

    /**
     * 保存/更新数据
     *
     * @param businessUnitCode 业务单元编码
     * @param exeDtoList       回调信息集合
     * @param indicatorVos     已有数据集合
     * @param itemCodes        明细编码集合
     */
    private void buildInfo(String businessUnitCode, List<PromotionActivityCallbackDataDto> exeDtoList, List<AuditExecuteIndicatorVo> indicatorVos, List<String> itemCodes) {
        if (CollectionUtils.isEmpty(exeDtoList) || CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(new Date());
        //默认查询的是前一天数据
        calendar.add(Calendar.DAY_OF_MONTH,-1);

        List<AuditExecuteIndicatorDto> list = new ArrayList<>();

        //活动细案
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            //查询出活动细案明细详情
            List<ActivityDetailPlanItemVo> itemVoList = activityDetailPlanItemSdkService.findByItemCodes(itemCodes);
            exeDtoList.forEach( exeDto -> {

                List<AuditExecuteIndicatorVo> indicatorVoList = indicatorVos.stream().filter(k -> exeDto.getZFCXHD().equals(k.getActiveNumber())).collect(Collectors.toList());

                if (!CollectionUtils.isEmpty(indicatorVoList)) {
                    indicatorVoList.forEach( indicator -> {
                        ActivityDetailPlanItemVo detailPlanItem = itemVoList.stream().filter(v -> exeDto.getZFCXHD().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                        try {
                            //更新
                            if(IndicatorNameEnum.SAP_QUANTITY.getCode().equals(indicator.getIndicatorName())){
                                AuditExecuteIndicatorDto amountDto = nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null);

                                this.filledOtherValues(amountDto,detailPlanItem,null);
                                amountDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank(exeDto.getZFXSSL().trim())) {
                                    amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                                }
                                list.add(amountDto);

                            }
                            if(IndicatorNameEnum.SAP_INCURRED.getCode().equals(indicator.getIndicatorName())){
                                AuditExecuteIndicatorDto incurredDto = nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null);

                                this.filledOtherValues(incurredDto,detailPlanItem,null);
                                incurredDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank(exeDto.getZFDDFY().trim())) {
                                    incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                                }
                                list.add(incurredDto);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("活动发生数量 ["+exeDto.getZFXSSL()+"] 或 活动发生金额 [" +exeDto.getZFDDFY()+"] 格式错误");
                        }
                    });

                }else {
                    ActivityDetailPlanItemVo detailPlanItem = itemVoList.stream().filter(v -> exeDto.getZFCXHD().equals(v.getDetailPlanItemCode())).findFirst().orElse(null);
                    if (ObjectUtils.isNotEmpty(detailPlanItem)) {
                        try {
                            //新增
                            AuditExecuteIndicatorDto amountDto = new AuditExecuteIndicatorDto();
                            amountDto.setYearAndMonth(calendar.getTime());
                            amountDto.setDockingSystem(AuditExecuteIndicatorConstant.SAP);
                            amountDto.setActiveNumber(exeDto.getZFCXHD());
                            if (StringUtils.isNotBlank(exeDto.getZFXSSL().trim())) {
                                amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                            }
                            amountDto.setIndicatorName(IndicatorNameEnum.SAP_QUANTITY.getCode());

                            AuditExecuteIndicatorDto incurredDto = new AuditExecuteIndicatorDto();
                            incurredDto.setYearAndMonth(calendar.getTime());
                            incurredDto.setDockingSystem(AuditExecuteIndicatorConstant.SAP);
                            incurredDto.setActiveNumber(exeDto.getZFCXHD());
                            if (StringUtils.isNotBlank(exeDto.getZFDDFY().trim())) {
                                incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                            }
                            incurredDto.setIndicatorName(IndicatorNameEnum.SAP_INCURRED.getCode());

                            this.filledOtherValues(amountDto,detailPlanItem,null);
                            this.filledOtherValues(incurredDto,detailPlanItem,null);
                            list.add(amountDto);
                            list.add(incurredDto);
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("活动发生数量 ["+exeDto.getZFXSSL()+"] 或 活动发生金额 [" +exeDto.getZFDDFY()+"] 格式错误");
                        }
                    }
                }

            });
        }

        //分子公司活动细案
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(businessUnitCode)) {
            //查询出分子公司活动细案明细详情
            List<SubComActivityDetailPlanItemVo> subComItemList = subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(itemCodes);

            exeDtoList.forEach( exeDto -> {
                List<AuditExecuteIndicatorVo> indicatorVoList = indicatorVos.stream().filter(k -> exeDto.getZFHDITEM().equals(k.getActiveNumber())).collect(Collectors.toList());

                if (!CollectionUtils.isEmpty(indicatorVoList)) {
                    indicatorVoList.forEach( indicator -> {
                        SubComActivityDetailPlanItemVo subComItem = subComItemList.stream().filter(v -> exeDto.getZFHDITEM().equals(v.getConstituentDetailPlanItemCode())).findFirst().orElse(null);
                        try {
                            //更新
                            if(IndicatorNameEnum.SAP_QUANTITY.getCode().equals(indicator.getIndicatorName())){
                                AuditExecuteIndicatorDto amountDto = nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null);

                                this.filledOtherValues(amountDto,null,subComItem);
                                amountDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank(exeDto.getZFXSSL().trim())) {
                                    amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                                }
                                list.add(amountDto);

                            }
                            if(IndicatorNameEnum.SAP_INCURRED.getCode().equals(indicator.getIndicatorName())){
                                AuditExecuteIndicatorDto incurredDto = nebulaToolkitService.copyObjectByWhiteList(indicator, AuditExecuteIndicatorDto.class, null, null);

                                this.filledOtherValues(incurredDto,null,subComItem);
                                incurredDto.setYearAndMonth(calendar.getTime());
                                if (StringUtils.isNotBlank(exeDto.getZFDDFY().trim())) {
                                    incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                                }
                                list.add(incurredDto);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("活动发生数量 ["+exeDto.getZFXSSL()+"] 或 活动发生金额 [" +exeDto.getZFDDFY()+"] 格式错误");
                        }
                    });
                }else {
                    SubComActivityDetailPlanItemVo subComItem = subComItemList.stream().filter(v -> exeDto.getZFHDITEM().equals(v.getConstituentDetailPlanItemCode())).findFirst().orElse(null);
                    if (ObjectUtils.isNotEmpty(subComItem)) {
                        try {
                            //新增
                            AuditExecuteIndicatorDto amountDto = new AuditExecuteIndicatorDto();
                            amountDto.setYearAndMonth(calendar.getTime());
                            amountDto.setDockingSystem(AuditExecuteIndicatorConstant.SAP);
                            amountDto.setActiveNumber(exeDto.getZFHDITEM());
                            if (StringUtils.isNotBlank(exeDto.getZFXSSL().trim())) {
                                amountDto.setIndicatorValue(new BigDecimal(exeDto.getZFXSSL().trim()));
                            }
                            amountDto.setIndicatorName(IndicatorNameEnum.SAP_QUANTITY.getCode());

                            AuditExecuteIndicatorDto incurredDto = new AuditExecuteIndicatorDto();
                            incurredDto.setYearAndMonth(calendar.getTime());
                            incurredDto.setDockingSystem(AuditExecuteIndicatorConstant.SAP);
                            incurredDto.setActiveNumber(exeDto.getZFHDITEM());
                            if (StringUtils.isNotBlank(exeDto.getZFDDFY().trim())) {
                                incurredDto.setIndicatorValue(new BigDecimal(exeDto.getZFDDFY().trim()));
                            }
                            incurredDto.setIndicatorName(IndicatorNameEnum.SAP_INCURRED.getCode());

                            this.filledOtherValues(amountDto,null,subComItem);
                            this.filledOtherValues(incurredDto,null,subComItem);
                            list.add(amountDto);
                            list.add(incurredDto);
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("活动发生数量 ["+exeDto.getZFXSSL()+"] 或 活动发生金额 [" +exeDto.getZFDDFY()+"] 格式错误");
                        }
                    }
                }

            });
        }

        auditExecuteIndicatorService.bulkImportSave(list);
    }

    /**
     * 填充其他属性
     *
     * @param exeDto     指标对象
     * @param detailPlanItem    活动细案明细
     * @param subComItem    分子公司活动细案明细
     */
    private void filledOtherValues(AuditExecuteIndicatorDto exeDto,ActivityDetailPlanItemVo detailPlanItem,SubComActivityDetailPlanItemVo subComItem) {
        if (ObjectUtils.isNotEmpty(detailPlanItem) && ObjectUtils.isNotEmpty(subComItem)) {
            //不可同时传入
            return;
        }

        if (ObjectUtils.isNotEmpty(detailPlanItem)) {
            if (!ObjectUtils.isEmpty(exeDto)) {
                exeDto.setBusinessFormatCode(detailPlanItem.getBusinessFormatCode());
                exeDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                exeDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
                exeDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
                exeDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
                exeDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
                exeDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
                exeDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
                exeDto.setChannelCode(detailPlanItem.getDistributionChannelCode());
                exeDto.setChannelName(detailPlanItem.getDistributionChannelName());
                exeDto.setCustomerCode(detailPlanItem.getCustomerCode());
                exeDto.setCustomerName(detailPlanItem.getCustomerName());
                exeDto.setStoresCode(detailPlanItem.getTerminalCode());
                exeDto.setStoresName(detailPlanItem.getTerminalName());
                exeDto.setPersonnelType(detailPlanItem.getPersonType());
                exeDto.setPersonnelId(detailPlanItem.getPersonCode());
                try {
                    exeDto.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityBeginDate()));
                    exeDto.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, detailPlanItem.getActivityEndDate()));
                } catch (Exception e) {
                    log.error("", e);
                }
                exeDto.setProductBrandCode(detailPlanItem.getProductBrandCode());
                exeDto.setProductBrandName(detailPlanItem.getProductBrandName());
                exeDto.setProductCategoryCode(detailPlanItem.getProductCategoryCode());
                exeDto.setProductCategoryName(detailPlanItem.getProductCategoryName());
                exeDto.setProductItemCode(detailPlanItem.getProductItemCode());
                exeDto.setProductItemName(detailPlanItem.getProductItemName());
                exeDto.setProductCode(detailPlanItem.getProductCode());
                exeDto.setProductName(detailPlanItem.getProductName());
                exeDto.setActivityFormCode(detailPlanItem.getActivityFormCode());
                exeDto.setActivityFormName(detailPlanItem.getActivityFormName());
                exeDto.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
                exeDto.setActivityTypeName(detailPlanItem.getActivityTypeName());
            }

        }

        if (ObjectUtils.isNotEmpty(subComItem)) {
            if (!ObjectUtils.isEmpty(exeDto)) {
                exeDto.setBusinessFormatCode(subComItem.getBusinessFormatCode());
                exeDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                exeDto.setSalesInstitutionCode(subComItem.getSalesInstitutionCode());
                exeDto.setSalesInstitutionName(subComItem.getSalesInstitutionName());
                exeDto.setSalesOrgCode(subComItem.getSalesOrgCode());
                exeDto.setSalesOrgName(subComItem.getSalesOrgName());
                exeDto.setChannelCode(subComItem.getDistributionChannelCode());
                exeDto.setChannelName(subComItem.getDistributionChannelName());
                if (!StringUtils.isBlank(subComItem.getCustomerCode()) && subComItem.getCustomerCode().length() <= 32) {
                    //过长的客户先不存在这里。
                    exeDto.setCustomerCode(subComItem.getCustomerCode());
                    exeDto.setCustomerName(subComItem.getCustomerName());
                }
                exeDto.setStoresCode(subComItem.getTerminalCode());
                exeDto.setStoresName(subComItem.getTerminalName());
                exeDto.setPersonnelType(subComItem.getPersonType());
                exeDto.setPersonnelId(subComItem.getPersonCode());
                try {
                    exeDto.setActivityBeginDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, subComItem.getActivityBeginTime()));
                    exeDto.setActivityEndDate(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd, subComItem.getActivityEndTime()));
                } catch (Exception e) {
                    log.error("", e);
                }
                exeDto.setProductBrandCode(subComItem.getProductBrandCode());
                exeDto.setProductBrandName(subComItem.getProductBrandName());
                exeDto.setProductCategoryCode(subComItem.getProductCategoryCode());
                exeDto.setProductCategoryName(subComItem.getProductCategoryName());
                exeDto.setProductItemCode(subComItem.getProductItemCode());
                exeDto.setProductItemName(subComItem.getProductItemName());
                exeDto.setProductCode(subComItem.getProductCode());
                exeDto.setProductName(subComItem.getProductName());
                exeDto.setActivityFormCode(subComItem.getActivityFormCode());
                exeDto.setActivityFormName(subComItem.getActivityFormName());
                exeDto.setActivityTypeCode(subComItem.getActivityType());
                exeDto.setActivityTypeName(subComItem.getActivityTypeName());
            }

        }

    }

    /**
     * SAP促销活动执行结果-总部回调
     * @param dto
     */
    @Override
    public void queryHeadCallback(PromotionActivityCallbackDto dto) {
    }
}
