package com.biz.crm.tpm.business.variable.local.executeIndicator.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.QueryPromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.SapActivityExecution;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 发送 SAP执行结果查询请求
 * @Author qiancheng
 * @Date 2023/2/14
 */
@Service("SapActivityExecution")
public class SapActivityExecutionImpl implements SapActivityExecution {

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private ActivityPushSapApiService activityPushSapApiService;
    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    @DynamicTaskService(cornExpression = "0 0 1,7,13,19 * * ?", taskDesc = "从sap查询拉取活动执行结果")
    public void queryAllExecutionSapBranch() {
        loginUserService.refreshAuthentication(null);
        List<QueryPromotionActivityBranchDto> dtoList = new ArrayList<>();
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(new Date());
        //拿到前一天
        calendar.add(Calendar.DAY_OF_MONTH,-1);
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        String lastDate = sif.format(calendar.getTime());

        //垂直活动查询条件
        QueryPromotionActivityBranchDto dtoVertical = new QueryPromotionActivityBranchDto();
        QueryPromotionActivityBranchDto.Item2 item2Vertical = new QueryPromotionActivityBranchDto.Item2();
        item2Vertical.setSIGN("I");
        item2Vertical.setOPTION(AuditExecuteIndicatorConstant.SAP_QUERY_OPTION_CP);
        item2Vertical.setLOW(AuditExecuteIndicatorConstant.SAP_QUERY_LOW_VERTICAL);
        dtoVertical.setITEM2(new ArrayList<>());
        dtoVertical.getITEM2().add(item2Vertical);
        QueryPromotionActivityBranchDto.Item4 item4Vertical = new QueryPromotionActivityBranchDto.Item4();
        item4Vertical.setSIGN("I");
        item4Vertical.setOPTION(AuditExecuteIndicatorConstant.SAP_QUERY_OPTION_EQ);
        item4Vertical.setLOW(lastDate);
        dtoVertical.setITEM4(new ArrayList<>());
        dtoVertical.getITEM4().add(item4Vertical);
        dtoList.add(dtoVertical);

        //分子活动查询条件
        QueryPromotionActivityBranchDto dtoMolecule = new QueryPromotionActivityBranchDto();
        QueryPromotionActivityBranchDto.Item2 item2Molecule = new QueryPromotionActivityBranchDto.Item2();
        item2Molecule.setSIGN("I");
        item2Molecule.setOPTION(AuditExecuteIndicatorConstant.SAP_QUERY_OPTION_CP);
        item2Molecule.setLOW(AuditExecuteIndicatorConstant.SAP_QUERY_LOW_MOLECULE);
        dtoMolecule.setITEM2(new ArrayList<>());
        dtoMolecule.getITEM2().add(item2Molecule);
        QueryPromotionActivityBranchDto.Item4 item4Molecule = new QueryPromotionActivityBranchDto.Item4();
        item4Molecule.setSIGN("I");
        item4Molecule.setOPTION(AuditExecuteIndicatorConstant.SAP_QUERY_OPTION_EQ);
        item4Molecule.setLOW(lastDate);
        dtoMolecule.setITEM4(new ArrayList<>());
        dtoMolecule.getITEM4().add(item4Molecule);
        dtoList.add(dtoMolecule);

        dtoList.forEach(dto -> {
            activityPushSapApiService.pushQueryPromotionActivityBranch(dto);
        });
    }

    @Override
    public void queryExecutionSapBranch(String orgCode,String itemCode,String activityDate) {
        Validate.notBlank(itemCode,"促销活动号不能为空！");
        String sapOrgCode = "";
        if(StringUtils.isNotBlank(orgCode)){
            List<String> list = new ArrayList<>();
            list.add(orgCode);
            //查询销售机构编码 对应的 sap编码
            Map<String, String> orgSapMap = salesOrgVoService.findSapCodesBySalesOrgCodes(list);
            Validate.notEmpty(orgSapMap,"未查询到销售组织对应的SAP编码");
            sapOrgCode = orgSapMap.get(orgCode);
            Validate.notBlank(sapOrgCode,"未查询到销售组织对应的SAP编码");
        }

        this.queryActivityExecutionFromSapBranch(sapOrgCode,itemCode,activityDate);

    }

    /**
     * 调用SAP活动执行查询接口 查询单个活动的执行信息（信息由回调返回）
     * @param orgCode sap销售组织编码
     * @param activityNo 促销活动号
     * @param activityDate 日期
     */
    private void queryActivityExecutionFromSapBranch(String orgCode,String activityNo,String activityDate) {
        if(StringUtils.isBlank(activityNo)){
            return;
        }
        QueryPromotionActivityBranchDto dto = new QueryPromotionActivityBranchDto();
        if(StringUtils.isNotBlank(orgCode)) {
            QueryPromotionActivityBranchDto.Item1 item1 = new QueryPromotionActivityBranchDto.Item1();
            item1.setSIGN("I");
            item1.setOPTION(AuditExecuteIndicatorConstant.SAP_QUERY_OPTION_EQ);
            item1.setLOW(orgCode);
            dto.setITEM1(new ArrayList<>());
            dto.getITEM1().add(item1);
        }
        QueryPromotionActivityBranchDto.Item2 item2 = new QueryPromotionActivityBranchDto.Item2();
        item2.setSIGN("I");
        item2.setOPTION(AuditExecuteIndicatorConstant.SAP_QUERY_OPTION_EQ);
        item2.setLOW(activityNo);
        dto.setITEM2(new ArrayList<>());
        dto.getITEM2().add(item2);
        if(StringUtils.isNotBlank(activityDate)) {
            QueryPromotionActivityBranchDto.Item4 item4 = new QueryPromotionActivityBranchDto.Item4();
            item4.setSIGN("I");
            item4.setOPTION(AuditExecuteIndicatorConstant.SAP_QUERY_OPTION_EQ);
            item4.setLOW(activityDate);
            dto.setITEM4(new ArrayList<>());
            dto.getITEM4().add(item4);
        }

        activityPushSapApiService.pushQueryPromotionActivityBranch(dto);
    }

}
