package com.biz.crm.tpm.business.variable.local.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractVariableEventDto;
import com.biz.crm.tpm.business.activity.contract.sdk.event.ActivityContractVariableEventListener;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivtiyContractVariableResponse;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/3/23 19:19
 * @description: 活动合同管理变量获取监听实现
 */
@Slf4j
@Component
public class ActivityContractVariableEventListenerImpl implements ActivityContractVariableEventListener {

    @Autowired(required = false)
    private VariableService variableService;

    @Override
    public ActivtiyContractVariableResponse getContractVariable(ActivityContractVariableEventDto eventDto) {
        ActivtiyContractVariableResponse variableResponse = new ActivtiyContractVariableResponse();
        if (StringUtils.isBlank(eventDto.getIsConfigure())) {
            return variableResponse;
        }
        eventDto.setFunction(VariableFunctionEnum.CONTRACT.getCode());
        List<RegisterVariableVo> list = variableService.variableList(eventDto.getIsConfigure(), eventDto.getFunction(), eventDto.getName(), null);
        if (!CollectionUtil.isEmpty(list)) {
            Map<String, String> map = list.stream().collect(Collectors.toMap(RegisterVariableVo::getName, RegisterVariableVo::getCode, (oldValue, newValue) -> newValue));
            variableResponse.setVarMap(map);
        }
        return variableResponse;
    }


}
