package com.biz.crm.tpm.business.variable.local.listener;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SapAmountEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.SapAmountListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SapAmountResponse;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/3/16 19:56
 * @description: 查询sap发生额通过活动细案编码 对外提供事件实现
 */
@Slf4j
@Component
public class SapAmountListenerImpl implements SapAmountListener {

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    /**
     * 查询sap发生额通过活动细案编码
     *
     * @param eventDto 事件dto
     * @return Map<String, BigDecimal>
     **/
    @Override
    public SapAmountResponse getSapAmountByDetailItemNos(SapAmountEventDto eventDto) {
        SapAmountResponse sapAmountResponse = new SapAmountResponse();
        if(CollectionUtils.isEmpty(eventDto.getItemNos())){
            sapAmountResponse.setAmountMap(Maps.newHashMap());
            return sapAmountResponse;
        }
        Map<String,BigDecimal> map = this.auditExecuteIndicatorService.getSapAmountByDetailItemNos(eventDto.getItemNos(), AuditExecuteIndicatorConstant.DICT_VALUE_SAP_OCCURRENCE_AMOUNT);
        sapAmountResponse.setAmountMap(map);
        return sapAmountResponse;
    }
}
