package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hd
 * @description：活动申请金额
 */
@Service
@Slf4j
public class ActivityApplicationAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Override
    public String getVariableCode() {
        return "activityApplicationAmount";
    }

    @Override
    public String getVariableName() {
        return "活动申请金额（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String detailPlanItemCode = calculateDto.getDetailPlanItemCode();
        Validate.notNull(detailPlanItemCode,"活动细案明细编码不能为空!");
//        List<String> list = new ArrayList<>(1);
//        list.add(activitiesDetailCode);
//        List<ActivityDetailPlanVo> byCodes = activityDetailPlanSdkService.findByCodes(list);
        Map<String,BigDecimal> resultMap = new HashMap<>(1);
        if (detailPlanItemCode.startsWith("DHD")) {
            // 差异追踪
            List<AuditFeeDiffTrackDetailVo> vos = auditFeeDiffTrackDetailVoService.findByDetailCodes(Lists.newArrayList(detailPlanItemCode));
            if(!CollectionUtils.isEmpty(vos)){
                resultMap.put(this.getVariableCode(), vos.get(0).getFeeAmount());
            }
        } else {
            // 细案
            List<ActivityDetailPlanItemVo> vos = activityDetailPlanItemSdkService.findByActivityDetailItemCodes(Sets.newHashSet(detailPlanItemCode), null);
            if(!CollectionUtils.isEmpty(vos)){
                resultMap.put(this.getVariableCode(), vos.get(0).getFeeAmount());
            }
        }
        if (!resultMap.containsKey(this.getVariableCode())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        }
        return resultMap;
    }
}
