package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;


import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: CostPlacementAIRegister
 * @description: 平台投放费用管理- AI 智投
 * @date: 2023/2/21 10:57.
 * @author: hb
 */

@Service
@Slf4j
public class CostPlacementAiRegister extends PutCostManageService implements FormulaVariableRegister {


    @Override
    public String getVariableCode() {
        return "costPlancementAi";
    }

    @Override
    public String getVariableName() {
        return "平台投放费用AI智投（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {

        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.platformDeliveryFeesValidate(calculateDto);

        BigDecimal putCostAmount = super.getPutCostAmount(calculateDto);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), putCostAmount);

        return resultMap;
    }
}
