package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.tpm.business.variable.local.register.ecommerce.MonthlySalesDistributionCommonService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: DistributorMonthlyBindAmountRegister
 * @description: 分销商月度捆绑销售金额
 * @date: 2023/2/20 20:39.
 * @author: hb
 */
@Service
@Slf4j
public class DistributorMonthlyBindAmountRegister extends MonthlySalesDistributionCommonService implements FormulaVariableRegister {


    @Override
    public String getVariableCode() {
        return "distributorMonthlyBindAmount";
    }

    @Override
    public String getVariableName() {
        return "分销商月度捆绑销售金额（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WITHHOLDING);
        list.add(VariableFunctionEnum.WARNING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        MonthlySalesDistributionAmountEnum bindSalesAmount = MonthlySalesDistributionAmountEnum.BIND_SALES_AMOUNT;

        super.monthlySalesDistributionVariable(calculateDto, bindSalesAmount);

        BigDecimal resultValue = super.getMonthlySalesDistributionValue(calculateDto, bindSalesAmount);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), resultValue);

        return resultMap;
    }
}
