package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @className: JingSpeedPushRegister
 * @description:
 * @date: 2023/2/21 14:37.
 * @author: hb
 */
@Service
@Slf4j
public class JingSpeedPushRegister extends PutCostManageService implements FormulaVariableRegister {

    private static final String ACTIVITY_TYPE_KEY = "jing_speed_push";

    @Override
    public String getVariableCode() {
        return "jingSpeedPush";
    }

    @Override
    public String getVariableName() {
        return "平台费用投放京速推（电商）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.WARNING);
        list.add(VariableFunctionEnum.WITHHOLDING);
        return list;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {

        super.platformDeliveryFeesValidate(calculateDto);

        BigDecimal putCostAmount = super.getPutCostAmount(calculateDto);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        resultMap.put(this.getVariableCode(), putCostAmount);

        return resultMap;
    }
}
