package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.VariableRegisterConstants;
import com.biz.crm.tpm.business.variable.local.register.vertical.common.VariableVerticalCommonBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author chenlong
 * @description：pos促销金额
 */
@Service
@Slf4j
public class PosPromotionDeductionRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required = false)
    private ProductVoService productVoService;
    @Autowired(required = false)
    private VariableVerticalCommonBuilder variableVerticalCommonBuilder;

    @Override
    public String getVariableCode() {
        return "posPromotionDeduction";
    }

    @Override
    public String getVariableName() {
        return "促销扣款金额(垂直)";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空");
        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notNull(calculateDto.getStartTimeOrDate(), "开始日期不能为空!");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "结束日期不能为空!");

        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        QueryConditionDto dto = new QueryConditionDto();
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            dto.setGoodsCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            ProductLevelDto levelDto = new ProductLevelDto();
            levelDto.setProductLevelCode(calculateDto.getItemCode());
            List<String> codes = productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            ProductLevelDto levelDto = new ProductLevelDto();
            levelDto.setProductCategoryCode(calculateDto.getCategoryCode());
            List<String> codes = productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            ProductLevelDto levelDto = new ProductLevelDto();
            levelDto.setProductBrandCode(calculateDto.getBrandCode());
            List<String> codes = productVoService.findProductCodesByProductLevel(levelDto);
            dto.setGoodCodes(codes);
        } else {
//            throw new RuntimeException("促销扣款金额(垂直)，未录入产品或者产品层级信息");
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            dto.setDeliveryPartyCode(calculateDto.getStoresCode());
        } else {
            Validate.notBlank(calculateDto.getRetailBusinessmanCode(), "零售商编码为空");
            Validate.notBlank(calculateDto.getActivityOrgCode(), "区域编码为空");
            dto.setCustomerRetailerCode(calculateDto.getRetailBusinessmanCode());
            dto.setBusinessArea(calculateDto.getActivityOrgCode());
        }

        List<String> channelNameList = variableVerticalCommonBuilder.getYongHuiChannelNameList(calculateDto);
        if (Objects.isNull(channelNameList)) {
            return resultMap;
        }

        String end = DateUtil.date_yyyy_MM_dd.format(calculateDto.getEndTimeOrDate());
        String start = DateUtil.date_yyyy_MM_dd.format(calculateDto.getStartTimeOrDate());
        dto.setEndTimeOrDate(end);
        dto.setStartTimeOrDate(start);
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setExcludeGoodCodes(calculateDto.getExcludeProductCodeList());
        dto.setChannelNameList(channelNameList);
        SalesDataVo salesDataVo = invoiceSalesDataVoService.findPromotionDeductionByCondition(dto);
        if (ObjectUtils.isEmpty(salesDataVo) || ObjectUtils.isEmpty(salesDataVo.getPromotionDeduction())) {
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), salesDataVo.getPromotionDeduction());
        return resultMap;
    }
}