package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.QueryConditionDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.local.register.vertical.common.VariableVerticalCommonBuilder;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hd
 * @description：pos销售量
 */
@Service
@Slf4j
public class PosSalesQuantityRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required = false)
    private VariableVerticalCommonBuilder variableVerticalCommonBuilder;
    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;


    @Override
    public String getVariableCode() {
        return "posSalesQuantity";
    }

    @Override
    public String getVariableName() {
        return "pos销售量（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String,BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);

        Date endTimeOrDate = calculateDto.getEndTimeOrDate();
        Validate.notNull(endTimeOrDate,"结束日期不能为空!");
        Date startTimeOrDate = calculateDto.getStartTimeOrDate();
        Validate.notNull(startTimeOrDate,"开始日期不能为空!");

        QueryConditionDto queryConditionDto = new QueryConditionDto();
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            queryConditionDto.setGoodsCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            ProductLevelDto levelDto = new ProductLevelDto();
            levelDto.setProductLevelCode(calculateDto.getItemCode());
            List<String> codes = productVoService.findProductCodesByProductLevel(levelDto);
            queryConditionDto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            ProductLevelDto levelDto = new ProductLevelDto();
            levelDto.setProductCategoryCode(calculateDto.getCategoryCode());
            List<String> codes = productVoService.findProductCodesByProductLevel(levelDto);
            queryConditionDto.setGoodCodes(codes);
        } else if (StringUtils.isNotEmpty(calculateDto.getBrandCode())) {
            ProductLevelDto levelDto = new ProductLevelDto();
            levelDto.setProductBrandCode(calculateDto.getBrandCode());
            List<String> codes = productVoService.findProductCodesByProductLevel(levelDto);
            queryConditionDto.setGoodCodes(codes);
        }

        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            queryConditionDto.setDeliveryPartyCode(calculateDto.getStoresCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getRetailBusinessmanName()) && StringUtils.isNotEmpty(calculateDto.getActivityOrgCode())) {
            queryConditionDto.setBusinessArea(calculateDto.getActivityOrgCode());
            queryConditionDto.setDirectName(calculateDto.getRetailBusinessmanName());
        } else {
            return resultMap;
        }

        String end = DateUtil.date_yyyy_MM_dd.format(endTimeOrDate);
        String start = DateUtil.date_yyyy_MM_dd.format(startTimeOrDate);
        queryConditionDto.setEndTimeOrDate(end);
        queryConditionDto.setStartTimeOrDate(start);

//        1038393 【细案预测管理】变量：pos销售量（垂直）计算错误
        String detailPlanItemCode = calculateDto.getDetailPlanItemCode();
        Validate.notNull(detailPlanItemCode,"活动细案明细编码不能为空!");
        if (detailPlanItemCode.startsWith("DHD")) {
            List<AuditFeeDiffTrackDetailVo> vos = auditFeeDiffTrackDetailVoService.findByDetailCodes(com.google.common.collect.Lists.newArrayList(detailPlanItemCode));
            String retailerChannel = vos.get(0).getRetailerChannel();
            if (StringUtils.isNotEmpty(retailerChannel) && !"全渠道".equals(retailerChannel)){
                queryConditionDto.setChannelNameList(Lists.newArrayList(retailerChannel));
            }
        } else {
            List<ActivityDetailPlanItemVo> vos = activityDetailPlanItemSdkService.findByActivityDetailItemCodes(Sets.newHashSet(detailPlanItemCode), null);
            String retailerChannel = vos.get(0).getRetailerChannel();
            if (StringUtils.isNotEmpty(retailerChannel) && !"全渠道".equals(retailerChannel)){
                queryConditionDto.setChannelNameList(Lists.newArrayList(retailerChannel));
            }
        }
        SalesDataVo salesDataVo= invoiceSalesDataVoService.findByCondition(queryConditionDto);
        if(ObjectUtils.isEmpty(salesDataVo) || ObjectUtils.isEmpty(salesDataVo.getCurUnitSalesQuantity())){
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), salesDataVo.getCurUnitSalesQuantity());
        return resultMap;
    }
}