package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import cn.hutool.json.JSONUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.put.cost.sdk.dto.ActivityPutCostDto;
import com.biz.crm.tpm.business.activity.put.cost.sdk.service.ActivityPutCostService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * @className: PutCostAmountService
 * @description: 平台投放费用管理
 * @date: 2023/2/21 13:58.
 * @author: hb
 */
@Service
@Slf4j
public abstract class PutCostManageService {

    @Autowired(required = false)
    private ActivityPutCostService activityPutCostService;

    public void platformDeliveryFeesValidate(CalculateDto calculate){

        log.info("平台投放费用管理-指标请求参数:{}", JSONUtil.toJsonStr(calculate));

        Validate.notNull(calculate.getCustomerCode(), "客户MDG编码不能为空");
        Validate.notBlank(calculate.getSalesOrganizationCode(), "销售机构不能为空");
        Validate.notBlank(calculate.getBusinessFormatCode(), "业态不能为空");
        Validate.notBlank(calculate.getChannel(), "渠道不能为空");
        Validate.notNull(calculate.getStartTimeOrDate(), "年月不能为空");
        Validate.notNull(calculate.getEndTimeOrDate(), "年月不能为空");
        Validate.notBlank(calculate.getActivityFormCode(), "活动形式编码不能为空");

    }

    public BigDecimal getPutCostAmount(CalculateDto calculate){

        ActivityPutCostDto activityPutCost = new ActivityPutCostDto();

        activityPutCost.setCustomerCode(calculate.getCustomerErpCode());
        activityPutCost.setSalesInstitutionCode(calculate.getSalesOrganizationCode());
        activityPutCost.setBusinessFormatCode(calculate.getBusinessFormatCode());
        activityPutCost.setChannelCode(calculate.getChannel());
        activityPutCost.setActivityFormCode(calculate.getActivityFormCode());
        activityPutCost.setPutCostDateBegin(DateUtil.format(calculate.getStartTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY) + " " + DateUtil.DAY_EARLIEST_TIME);
        activityPutCost.setPutCostDateEnd(DateUtil.format(calculate.getEndTimeOrDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY) + " " + DateUtil.DAY_EARLIEST_TIME);
        return activityPutCostService.getPutCostAmount(activityPutCost);
    }
}
