package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hd
 * @description：SAP发生额
 */
@Service
@Slf4j
public class SapOccurrenceAmountRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Override
    public String getVariableCode() {
        return "sapOccurrenceAmount";
    }

    @Override
    public String getVariableName() {
        return "SAP发生额";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String detailPlanItemCode = calculateDto.getDetailPlanItemCode();
        Validate.notNull(detailPlanItemCode, "活动细案明细编码不能为空!");
        List<AuditExecuteIndicatorVo> byCode = auditExecuteIndicatorService.findByCode(detailPlanItemCode, QueryConstant.INDICATOR_NAME_SAP_OCCURRENCE_AMOUNT);
        Map<String,BigDecimal> resultMap = new HashMap<>(1);
        if(CollectionUtils.isEmpty(byCode)){
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), byCode.get(0).getIndicatorValue());
        return resultMap;
    }
}