package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator;

import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubCompanyExecuteIndicatorUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/14 13:49
 * @description：门店GMV
 */
@Service
@Slf4j
public class StoreGMVRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SubCompanyExecuteIndicatorUtil subCompanyExecuteIndicatorUtil;

    @Override
    public String getVariableCode() {
        return "storeGmv";
    }

    @Override
    public String getVariableName() {
        return "门店GMV（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    //    @Override
//    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//
//        Validate.notNull(calculateDto.getCustomerCode(),"客户编码不能为空");
//        Validate.notNull(calculateDto.getSalesOrgCode(),"销售组织不能为空");
//        Validate.notNull(calculateDto.getYearMonthLy(),"年月不能为空");
//        Validate.notNull(calculateDto.getBusinessFormatCode(),"业态不能为空");
//        Validate.notNull(calculateDto.getBusinessUnitCode(),"业务单元不能为空");
//
//        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
//        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
//        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
//        dto.setCustomerCode(calculateDto.getCustomerCode());
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
//        try {
//            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
//        } catch (ParseException e) {
//            log.error(e.getMessage(),e);
//            e.printStackTrace();
//        }
//        dto.setSalesOrgCode(calculateDto.getSalesOrgCode());
//        dto.setStoresCode(calculateDto.getStoresCode());
//        dto.setIndicatorCode(this.getVariableCode());
//        List<AuditExecuteIndicatorVo> resultList = auditExecuteIndicatorService.findListByCondition(dto);
//        if(CollectionUtils.isEmpty(resultList)){
//            Map<String,BigDecimal> resultMap = new HashMap<>();
//            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
//            return resultMap;
//        }
//        Map<String,BigDecimal> resultMap = new HashMap<>();
//        resultMap.put(this.getVariableCode(),resultList.get(0).getIndicatorValue());
//        return resultMap;
//    }
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), subCompanyExecuteIndicatorUtil.getValue(calculateDto, this.getVariableCode()));
        return resultMap;
    }
}
