package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-17
 */
@Slf4j
public class AuditExecuteIndicatorParamBuilder {

    /**
     * 执行指标查询参数构建-第一优先级参数
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public static AuditExecuteIndicatorDto buildMainParam(CalculateDto calculateDto, String variableCode) {
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setVariableCode(variableCode);
        if (StringUtils.isNotEmpty(calculateDto.getDetailPlanItemCode())) {
            dto.setActiveNumber(calculateDto.getDetailPlanItemCode());
        }
        Validate.isTrue(StringUtils.isNotEmpty(dto.getActiveNumber()) || otherParamsVal(dto), "缺少必要参数！");
        return dto;
    }

    /**
     * 执行指标查询参数构建-非第一优先级参数
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public static AuditExecuteIndicatorDto buildOtherParam(CalculateDto calculateDto, String variableCode) {
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月为空");
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setCustomerCode(calculateDto.getCustomerCode());
        dto.setChannelCode(calculateDto.getChannel());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        } catch (ParseException e) {
            log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        dto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        dto.setStoresCode(calculateDto.getStoresCode());
        dto.setVariableCode(variableCode);
        Validate.isTrue(StringUtils.isNotEmpty(dto.getActiveNumber()) || otherParamsVal(dto), "缺少必要参数！");
        return dto;
    }

    /**
     * 执行指标查询参数构建-分子
     *
     * @param calculateDto
     * @param indicatorCode
     * @return
     */
    public static AuditExecuteIndicatorDto buildSubCompanyParam(CalculateDto calculateDto, String indicatorCode) {
        Validate.notBlank(calculateDto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(calculateDto.getBusinessUnitCode(), "业务单元不能为空！");
        Validate.notBlank(calculateDto.getCustomerCode(), "客户编码不能为空！");
        Validate.notBlank(calculateDto.getSalesOrganizationCode(), "销售机构编码不能为空！");
        Validate.notBlank(calculateDto.getDistributionChannel(), "分销渠道不能为空！");
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空！");

        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setCustomerCodes(Arrays.asList(calculateDto.getCustomerCode().split(",")));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        } catch (ParseException e) {
            log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            dto.setStoresCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
        }
        dto.setIndicatorCode(indicatorCode);
        return dto;
    }

    public static boolean otherParamsVal(AuditExecuteIndicatorDto calculateDto) {
        return StringUtils.isNotEmpty(calculateDto.getBusinessFormatCode())
                || StringUtils.isNotEmpty(calculateDto.getBusinessUnitCode())
                || StringUtils.isNotEmpty(calculateDto.getCustomerCode())
                || Objects.nonNull(calculateDto.getYearAndMonth())
                || StringUtils.isNotEmpty(calculateDto.getYearStr())
                || StringUtils.isNotEmpty(calculateDto.getSalesInstitutionCode())
                || StringUtils.isNotEmpty(calculateDto.getSalesRegionCode())
                || StringUtils.isNotEmpty(calculateDto.getSalesOrgCode())
                || StringUtils.isNotEmpty(calculateDto.getStoresCode())
                || Objects.nonNull(calculateDto.getActivityBeginDate())
                || Objects.nonNull(calculateDto.getActivityEndDate())
                || StringUtils.isNotEmpty(calculateDto.getCustomerRetailerCode())
                || StringUtils.isNotEmpty(calculateDto.getPersonIdCard())
                || StringUtils.isNotEmpty(calculateDto.getFirstChannelCode())
                || StringUtils.isNotEmpty(calculateDto.getSecondChannelCode())
                || StringUtils.isNotEmpty(calculateDto.getProductBrandCode())
                || StringUtils.isNotEmpty(calculateDto.getProductCategoryCode())
                || StringUtils.isNotEmpty(calculateDto.getProductItemCode())
                || StringUtils.isNotEmpty(calculateDto.getProductCode())
                || StringUtils.isNotEmpty(calculateDto.getHeadBudgetItemCode())
                || StringUtils.isNotEmpty(calculateDto.getMonthBudgetCode())
                || StringUtils.isNotEmpty(calculateDto.getSpecification())
                || StringUtils.isNotEmpty(calculateDto.getIsTemporary())
                || StringUtils.isNotEmpty(calculateDto.getIndicatorCode())
                || CollectionUtils.isNotEmpty(calculateDto.getCustomerCodes())
                || CollectionUtils.isNotEmpty(calculateDto.getStoresCodes())
                || CollectionUtils.isNotEmpty(calculateDto.getProductCodeList())
                || CollectionUtils.isNotEmpty(calculateDto.getProductItemCodeList())
                || CollectionUtils.isNotEmpty(calculateDto.getProductCategoryCodeList())
                || CollectionUtils.isNotEmpty(calculateDto.getProductBrandCodeList())
                || StringUtils.isNotEmpty(calculateDto.getActivityTypeCode())
                || StringUtils.isNotEmpty(calculateDto.getActivityFormCode())
                || StringUtils.isNotEmpty(calculateDto.getChannelCode())
                ;
    }
}
