package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common;

/**
 * <p>
 * 公式计算和执行指标字段映射关系
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-25
 */
public enum ExecutorIndicatorParamReflectEnum {

    detailPlanItemCode("detailPlanItemCode", "activeNumber", false),
    customerCode("customerCode", "customerCode", false),
    customerCodeList("customerCodeList", "customerCodes", false),
    customerErpCode("customerErpCode", "customerErpCode", false),
    yearMonthLy("yearMonthLy", "yearAndMonthStr", false),
    businessFormatCode("businessFormatCode", "businessFormatCode", false),
    businessUnitCode("businessUnitCode", "businessUnitCode", false),
    salesOrganizationCode("salesOrganizationCode", "salesInstitutionCode", false),
    salesOrganizationErpCode("salesOrganizationErpCode", "salesInstitutionErpCode", false),
    salesRegionCode("salesRegionCode", "salesRegionCode", false),
    salesRegionErpCode("salesRegionErpCode", "salesRegionErpCode", false),
    salesGroupCode("salesGroupCode", "salesOrgCode", false),
    salesGroupErpCode("salesGroupErpCode", "salesOrgErpCode", false),
    channel("channel", "channelCode", false),
    storesCode("storesCode", "storesCodes", true),
    brandCode("brandCode", "productBrandCodeList", true),
    categoryCode("categoryCode", "productCategoryCodeList", true),
    itemCode("itemCode", "productItemCodeList", true),
    productCode("productCode", "productCodeList", true),
    ;


    private String srcProperty;
    private String destProperty;
    private boolean split;

    ExecutorIndicatorParamReflectEnum(String srcProperty, String destProperty, boolean split) {
        this.srcProperty = srcProperty;
        this.destProperty = destProperty;
        this.split = split;
    }

    public static ExecutorIndicatorParamReflectEnum getBySrcProperty(String srcProperty) {
        for (ExecutorIndicatorParamReflectEnum value : ExecutorIndicatorParamReflectEnum.values()) {
            if (value.srcProperty.equals(srcProperty)) {
                return value;
            }
        }
        return null;
    }

    public String getSrcProperty() {
        return srcProperty;
    }

    public String getDestProperty() {
        return destProperty;
    }

    public boolean isSplit() {
        return split;
    }
}
