package com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common;

import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesDto;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-17
 */
@Slf4j
public class SubComAuditExecuteIndicatorParamBuilder {

    /**
     * 执行指标查询参数构建-非第一优先级参数
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public static List<AuditExecuteIndicatorDto> buildOtherParamList(CalculateDto calculateDto, String variableCode) {
        List<AuditExecuteIndicatorDto> list = new ArrayList<>();
        if (StringUtils.isNotEmpty(calculateDto.getCustomerCode())) {
            AuditExecuteIndicatorDto customerDto = buildOtherParam(calculateDto, variableCode);
            customerDto.setCustomerCode(calculateDto.getCustomerCode());
            list.add(customerDto);
        } else {
            list.add(null);
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            AuditExecuteIndicatorDto terminalDto = buildOtherParam(calculateDto, variableCode);
            terminalDto.setStoresCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            list.add(terminalDto);
        } else {
            list.add(null);
        }
        return list;
    }

    private static AuditExecuteIndicatorDto buildOtherParam(CalculateDto calculateDto, String variableCode) {
        Validate.notBlank(calculateDto.getYearMonthLy(), "年月为空");
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setChannelCode(calculateDto.getChannel());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        } catch (ParseException e) {
            log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        dto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        dto.setVariableCode(variableCode);
        Validate.isTrue(StringUtils.isNotEmpty(dto.getActiveNumber()) || AuditExecuteIndicatorParamBuilder.otherParamsVal(dto), "缺少必要参数！");
        return dto;
    }

    /**
     * 执行指标查询参数构建-分子
     *
     * @param calculateDto
     * @param variableCode
     * @return
     */
    public static List<AuditExecuteIndicatorDto> buildSubComParamList(CalculateDto calculateDto, String variableCode) {
        List<AuditExecuteIndicatorDto> list = new ArrayList<>();
        if (StringUtils.isNotEmpty(calculateDto.getCustomerCode())) {
            AuditExecuteIndicatorDto customerDto = buildSubComParam(calculateDto, variableCode);
            customerDto.setCustomerCode(calculateDto.getCustomerCode());
            list.add(customerDto);
        } else {
            list.add(null);
        }
        if (StringUtils.isNotEmpty(calculateDto.getStoresCode())) {
            AuditExecuteIndicatorDto terminalDto = buildSubComParam(calculateDto, variableCode);
            terminalDto.setStoresCodes(Arrays.asList(calculateDto.getStoresCode().split(",")));
            list.add(terminalDto);
        } else {
            list.add(null);
        }
        return list;
    }

    private static AuditExecuteIndicatorDto buildSubComParam(CalculateDto calculateDto, String variableCode) {
        Validate.notNull(calculateDto.getYearMonthLy(), "年月不能为空！");
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            dto.setYearAndMonth(sdf.parse(calculateDto.getYearMonthLy()));
        } catch (ParseException e) {
            log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        dto.setSalesInstitutionCode(calculateDto.getSalesOrganizationCode());
        dto.setIndicatorCode(variableCode);
        return dto;
    }
}
