package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description:商超费用-细案预测金额
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Service
@Slf4j
public class AuditFeeVariableP0001Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0001";
    }

    @Override
    public String getVariableName() {
        return "细案预测金额";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        if (Objects.isNull(calculateDto)
                || StringUtils.isBlank(calculateDto.getActivityDetailItemCode())
                || CollectionUtils.isEmpty(calculateDto.getActivityDetailItemCodeList())) {
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
        }

        List<String> codes = new ArrayList<>();
        if (!CollectionUtils.isEmpty(calculateDto.getActivityDetailItemCodeList())) {
            codes = calculateDto.getActivityDetailItemCodeList();
        }
        if (!StringUtils.isBlank(calculateDto.getActivityDetailItemCode())) {
            codes.add(calculateDto.getActivityDetailItemCode());
        }
        //查预故核销金额
        List<DetailedForecastVo> detailedForecastList = detailedForecastService.findEstimatedWriteOffAmountByCodes(codes);
        log.info("AUDITFEEP0001:{}", JSONObject.toJSONString(detailedForecastList));
        if (CollectionUtils.isEmpty(detailedForecastList)) {
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
        }else {
            resultMap.put(this.getVariableCode(),Optional.ofNullable(detailedForecastList.get(0).getEstimatedWriteOffAmount()).orElse(BigDecimal.ZERO));
        }
        log.info("AUDITFEEP0001resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
