package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.service.InvoiceAcceptanceVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:商超费用-验收金额(含税)
 * @Author qiancheng
 * @Date 2023/9/28
 */
@Service
@Slf4j
public class AuditFeeVariableP0003Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private InvoiceAcceptanceVoService invoiceAcceptanceVoService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0003";
    }

    @Override
    public String getVariableName() {
        return "验收金额(含税)";
    }

    @Override
    public Integer getSort() {
        return 3;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        //返回值的键为客户编码（37码）+"_"+产品编码（13码）例如3793517501_130100003042
        Map<String,BigDecimal> resultMap = new HashMap<>();

        Validate.notNull(calculateDto,"参数不能为空！");
        Validate.notNull(calculateDto.getProductList(),"产品编码不能为空!");
        Validate.notNull(calculateDto.getStoreList(),"客户编码不能为空！");
        Validate.notNull(calculateDto.getStartTimeOrDate(),"开始时间不能为空！");
        Validate.notNull(calculateDto.getEndTimeOrDate(),"结束时间不能为空！");
        InvoiceAcceptanceDto dto = new InvoiceAcceptanceDto();
        dto.setQueryType("1");//1为查询含税
        dto.setProductCodeList(calculateDto.getProductList());
        dto.setTerminalCodeList(calculateDto.getStoreList());
        dto.setStartDate(DateUtil.format(calculateDto.getStartTimeOrDate(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
        dto.setEndDate(DateUtil.format(calculateDto.getEndTimeOrDate(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
        Map<String, BigDecimal> result = invoiceAcceptanceVoService.findAcceptanceAmountByStoreAndProduct(dto);
        log.info("AUDITFEEP0003:{}", JSONObject.toJSONString(result));
        if (result.get(calculateDto.getStoreList().get(0)+"_"+calculateDto.getProductList().get(0)) != null) {
            resultMap.put(this.getVariableCode(),result.get(calculateDto.getStoreList().get(0)+"_"+calculateDto.getProductList().get(0)));
        }else {
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
        }
        log.info("AUDITFEEP0003resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
