package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementAccptanceDto;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:商超费用-结算验收金额(未税)
 * @Author qiancheng
 * @Date 2023/9/28
 */
@Service
@Slf4j
public class AuditFeeVariableP0004Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private InvoiceStatementVoService invoiceStatementVoService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0004";
    }

    @Override
    public String getVariableName() {
        return "结算验收金额(未税)";
    }

    @Override
    public Integer getSort() {
        return 4;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        //返回值的键为客户编码（37码）
        Validate.notNull(calculateDto,"参数不能为空！");
        Validate.notNull(calculateDto.getStoreList(),"客户编码不能为空！");
        Validate.notNull(calculateDto.getStartTimeOrDate(),"开始时间不能为空！");
        Validate.notNull(calculateDto.getEndTimeOrDate(),"结束时间不能为空！");
        InvoiceStatementAccptanceDto dto = new InvoiceStatementAccptanceDto();
        dto.setQueryType("2");//2为查询未税
        dto.setStoreCodes(calculateDto.getStoreList());
        dto.setStartDate(DateUtil.format(calculateDto.getStartTimeOrDate(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
        dto.setEndDate(DateUtil.format(calculateDto.getEndTimeOrDate(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
        Map<String, BigDecimal> result = invoiceStatementVoService.findStatementAcceptanceAmountByStoreAndProduct(dto);
        log.info("AUDITFEEP0004:{}", JSONObject.toJSONString(result));
        Map<String,BigDecimal> resultMap = new HashMap<>();
        if (result.get(calculateDto.getStoreList().get(0)) != null) {
            resultMap.put(this.getVariableCode(),result.get(calculateDto.getStoreList().get(0)));
        }else {
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
        }
        log.info("AUDITFEEP0004resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
