package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @Description:商超费用-POS（未税）
 * @Author qiancheng
 * @Date 2023/9/28
 */
@Service
@Slf4j
public class AuditFeeVariableP0006Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0006";
    }

    @Override
    public String getVariableName() {
        return "POS（未税）";
    }

    @Override
    public Integer getSort() {
        return 6;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        Validate.notNull(calculateDto,"参数不能为空！");
        Validate.notBlank(calculateDto.getProductCode(),"产品编码不能为空!");
        Validate.notBlank(calculateDto.getDeliveryPartyCode(),"送达方编码不能为空！");
        Validate.notNull(calculateDto.getStartTimeOrDate(),"开始时间不能为空！");
        Validate.notNull(calculateDto.getEndTimeOrDate(),"结束时间不能为空！");
        SalesDataDto selectDto = new SalesDataDto();
        selectDto.setGoodsCode(calculateDto.getProductCode());
        selectDto.setDeliveryPartyCode(calculateDto.getDeliveryPartyCode());
        selectDto.setStartTime(DateUtil.format(calculateDto.getStartTimeOrDate(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
        selectDto.setEndTime(DateUtil.format(calculateDto.getEndTimeOrDate(),DateUtil.DEFAULT_YEAR_MONTH_DAY));
        selectDto.setTaxOrNot(BooleanEnum.TRUE.getNumStr());
        BigDecimal variable = invoiceSalesDataVoService.findSummaryForVariable(selectDto);
        resultMap.put(this.getVariableCode(), Optional.ofNullable(variable).orElse(BigDecimal.ZERO));
        log.info("AUDITFEEP0006resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
