package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description:商超费用-产品税率
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Service
@Slf4j
public class AuditFeeVariableP0012Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0012";
    }

    @Override
    public String getVariableName() {
        return "产品税率";
    }

    @Override
    public Integer getSort() {
        return 12;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        if (Objects.isNull(calculateDto)
                || StringUtils.isBlank(calculateDto.getProductCode())
                || CollectionUtils.isEmpty(calculateDto.getExcludeProductCodeList())) {
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
        }

        List<String> codes = new ArrayList<>();
        if (!CollectionUtils.isEmpty(calculateDto.getExcludeProductCodeList())) {
            codes = calculateDto.getExcludeProductCodeList();
        }
        if (!StringUtils.isBlank(calculateDto.getProductCode())) {
            codes.add(calculateDto.getProductCode());
        }
        List<ProductVo> productList = productVoService.findRateByProductCodes(codes);
        log.info("AUDITFEEP0012:{}", JSONObject.toJSONString(productList));
        if (CollectionUtils.isEmpty(productList)) {
            resultMap.put(this.getVariableCode(),BigDecimal.ZERO);
        }else {
            resultMap.put(this.getVariableCode(),Optional.ofNullable(productList.get(0).getRate()).orElse(BigDecimal.ZERO));
        }
        log.info("AUDITFEEP00012resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
