package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @Description:商超费用-单件申请费用
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Service
@Slf4j

public class AuditFeeVariableP0014Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0014";
    }

    @Override
    public String getVariableName() {
        return "单件申请费用";
    }

    @Override
    public Integer getSort() {
        return 14;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        if (Objects.isNull(calculateDto) || StringUtils.isBlank(calculateDto.getCode()) || StringUtils.isBlank(calculateDto.getDataSource())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        }
        String dataSource = calculateDto.getDataSource();
        BigDecimal singleApplicationFee = BigDecimal.ZERO;
        if (DataSourceEnum.ACTIVITY_DETAIL.getCode().equals(dataSource)) {
            List<ActivityDetailPlanItemVo> itemVos = activityDetailPlanItemSdkService.findDetailAndExtendByItemCodes(Lists.newArrayList(calculateDto.getCode()));
            if (!CollectionUtils.isEmpty(itemVos)) singleApplicationFee = itemVos.get(0).getSingleApplicationFee();
        } else if (DataSourceEnum.SON_ACTIVITY_DETAIL.getCode().equals(dataSource)) {
//            List<SubComActivityDetailPlanItemVo> subItemVos = subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(Lists.newArrayList(calculateDto.getCode()));
//            if (!CollectionUtils.isEmpty(subItemVos)) applyAmount = subItemVos.get(0).getCustomerFeeAmount();
        }
        resultMap.put(this.getVariableCode(), singleApplicationFee);

        log.info("AUDITFEEP00014resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
