package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.constant.AuditExecuteIndicatorConstant;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @Description:商超费用-陈列扣减金额
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Service
@Slf4j

public class AuditFeeVariableP0015Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0015";
    }

    @Override
    public String getVariableName() {
        return "陈列扣减金额";
    }

    @Override
    public Integer getSort() {
        return 15;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        if (Objects.isNull(calculateDto) || StringUtils.isBlank(calculateDto.getCode()) || StringUtils.isBlank(calculateDto.getBusinessFormatCode()) || StringUtils.isBlank(calculateDto.getBusinessUnitCode())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        BigDecimal displayDeductAmount = BigDecimal.ZERO;
        // 查执行指标表
        AuditExecuteIndicatorDto dto = new AuditExecuteIndicatorDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setActiveNumber(calculateDto.getCode());
        dto.setDockingSystem(AuditExecuteIndicatorConstant.COW_MANAGER);
        dto.setIndicatorName(QueryConstant.INDICATOR_NAME_DEDUCTION_AMOUNT);
        List<AuditExecuteIndicatorVo> list = auditExecuteIndicatorService.findListForVariable(dto);

        if (!CollectionUtils.isEmpty(list)) displayDeductAmount = list.get(0).getIndicatorValue();
        resultMap.put(this.getVariableCode(), displayDeductAmount);

        log.info("AUDITFEEP00015resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
