package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @Description:商超费用-POS促销扣款（含税）
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Service
@Slf4j
public class AuditFeeVariableP0016Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private AuditFeeCheckPosVoService auditFeeCheckPosVoService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0016";
    }

    @Override
    public String getVariableName() {
        return "POS促销扣款（含税）";
    }

    @Override
    public Integer getSort() {
        return 7;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        log.info("AUDITFEEP0016param:{}", JSONObject.toJSONString(calculateDto));
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        if (Objects.isNull(calculateDto) || StringUtils.isBlank(calculateDto.getCode())
            || StringUtils.isBlank(calculateDto.getActivityDetailItemCode())
            || StringUtils.isBlank(calculateDto.getBusinessFormatCode())
            || StringUtils.isBlank(calculateDto.getBusinessUnitCode())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        BigDecimal displayDeductAmount = BigDecimal.ZERO;
        // 查执行指标表
        AuditFeeCheckPosDto dto = new AuditFeeCheckPosDto();
        dto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        dto.setActivityDetailItemCode(calculateDto.getActivityDetailItemCode());
        PageRequest page = PageRequest.of(1, 1000);
        Page<AuditFeeCheckPosVo> result;
        do {
            result = auditFeeCheckPosVoService.findByConditions(page, dto);
            log.info("AUDITFEEP0016detailItemCode:{},result:{}", calculateDto.getActivityDetailItemCode(), JSONObject.toJSONString(result));
            if (result == null) break;
            // 取促销扣款金额的汇总
            if (!CollectionUtils.isEmpty(result.getRecords())) {
                displayDeductAmount = displayDeductAmount.add(result.getRecords().stream().map(AuditFeeCheckPosVo::getPromotionDeduction)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        } while (result.hasNext());

        resultMap.put(this.getVariableCode(), displayDeductAmount);

        log.info("AUDITFEEP0016detailItemCode:{}, resultMap:{}", calculateDto.getActivityDetailItemCode(), JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
