package com.biz.crm.tpm.business.variable.local.register.auditFee;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Description:商超费用-促销费用（含税）
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Service
@Slf4j
public class AuditFeeVariableP0017Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;

    @Override
    public String getVariableCode() {
        return "AUDITFEEP0017";
    }

    @Override
    public String getVariableName() {
        return "促销费用（含税）";
    }

    @Override
    public Integer getSort() {
        return 17;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.AUDIT_FEE);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        log.info("AUDITFEEP00017param:{}", JSONObject.toJSONString(calculateDto));
        if (Objects.isNull(calculateDto) || StringUtils.isBlank(calculateDto.getCode())
            || StringUtils.isBlank(calculateDto.getBusinessFormatCode()) || StringUtils.isBlank(calculateDto.getBusinessUnitCode())
            || StringUtils.isBlank(calculateDto.getRetailBusinessmanCode()) || StringUtils.isBlank(calculateDto.getDeliveryPartyCode())
            || StringUtils.isBlank(calculateDto.getProductCode()) || StringUtils.isBlank(calculateDto.getYearMonthLy())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        BigDecimal displayDeductAmount = BigDecimal.ZERO;
        // 查KMS 零售商费用单
        InvoiceExpenseSheetDto sheetDto = new InvoiceExpenseSheetDto();
        sheetDto.setUrl("促销");
        sheetDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        sheetDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        sheetDto.setCustomerRetailerCode(calculateDto.getRetailBusinessmanCode());
        sheetDto.setDeliveryPartyCode(calculateDto.getDeliveryPartyCode());
        sheetDto.setProductCode(calculateDto.getProductCode());
        sheetDto.setOrderYearMonth(calculateDto.getYearMonthLy());

        log.info("AUDITFEEP00017dto:{}", JSONObject.toJSONString(sheetDto));
        BigDecimal bigDecimal = invoiceExpenseSheetVoService.promotionExpensesForFormula(sheetDto);
        log.info("AUDITFEEP00017apiResult:{}", JSONObject.toJSONString(bigDecimal));
        displayDeductAmount = bigDecimal == null ? displayDeductAmount : bigDecimal;

        resultMap.put(this.getVariableCode(), displayDeductAmount);

        log.info("AUDITFEEP00017resultMap:{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }
}
