package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.register.common.VariableCommonConstants;
import com.biz.crm.tpm.business.variable.local.utils.BigDecimalUtils;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 活动期间及活动产品折后销售额（不含奶卡）
 */
@Service
@Slf4j
public class ActivityDiscountedSalesRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Override
    public String getVariableCode() {
        return "activityDiscountedSales";
    }

    @Override
    public String getVariableName() {
        return "活动期间及活动产品折后销售额（不含奶卡）（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getStartTimeOrDate(), "活动开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(), "活动结束时间不能为空");
        Validate.notNull(calculateDto.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notNull(calculateDto.getBusinessFormatCode(), "业态不能为空");
        Validate.notEmpty(calculateDto.getCustomerCodeList(), "客户编码不能为空");
//        //品项编码
//        String itemCode = calculateDto.getItemCode();
//        //品类编码
//        String categoryCode = calculateDto.getCategoryCode();
//        //品牌编码
//        String brandCode = calculateDto.getBrandCode();
//        //产品编码
//        String productCode = calculateDto.getProductCode();

        MainOnedaySalesDataDto mainOnedaySalesData = new MainOnedaySalesDataDto();
//        if (StringUtils.isNotEmpty(itemCode)
//                && StringUtils.isNotEmpty(categoryCode)
//                && StringUtils.isNotEmpty(brandCode) && StringUtils.isNotEmpty(productCode)){
//            mainOnedaySalesData.setProductCode(productCode);
//        }
//        if (StringUtils.isEmpty(productCode)
//                && StringUtils.isEmpty(itemCode)
//                && StringUtils.isNotEmpty(brandCode)
//                && StringUtils.isNotEmpty(categoryCode)){
//            mainOnedaySalesData.setProductCategoryCode(categoryCode);
//        }
        if (StringUtils.isNotEmpty(calculateDto.getProductCode())) {
            mainOnedaySalesData.setProductCodes(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty(calculateDto.getItemCode())) {
            mainOnedaySalesData.setProductItemCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty(calculateDto.getCategoryCode())) {
            mainOnedaySalesData.setProductCategoryCode(calculateDto.getCategoryCode());
        }  else if (StringUtils.isNotEmpty(calculateDto.getBrandCode()) && !StringUtils.equals(VariableCommonConstants.allBrandCode, calculateDto.getBrandCode())) {
            mainOnedaySalesData.setProductBrandCode(calculateDto.getBrandCode());
        }

        mainOnedaySalesData.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        mainOnedaySalesData.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        mainOnedaySalesData.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        SimpleDateFormat format = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
        String startDate = format.format(calculateDto.getStartTimeOrDate());
        mainOnedaySalesData.setStartTimeOrDate(startDate);
        String endDate = format.format(calculateDto.getEndTimeOrDate());
        mainOnedaySalesData.setEndTimeOrDate(endDate);

        List<MainOnedaySalesDataVo> resultList = mainOnedaySaleDataService.listMainOnedaySalesData(mainOnedaySalesData);

        Map<String, BigDecimal> resultMap = Maps.newHashMap();

        BigDecimal resultDecimal = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(resultList)){
            resultMap.put(this.getVariableCode(), resultDecimal);
            return resultMap;
        }
        resultDecimal = resultList
                .stream()
                .map(MainOnedaySalesDataVo::getMinusDiscountBehindTaxSaleAmount)
                .collect(Collectors.toList())
                .stream()
                .reduce(BigDecimal.ZERO, BigDecimalUtils::sum);

        resultMap.put(this.getVariableCode(), resultDecimal);
        return resultMap;
    }

}
