package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 申请金额
 */
@Service
@Slf4j
public class ApplyAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Override
    public String getVariableCode() {
        return "applyAmount";
    }

    @Override
    public String getVariableName() {
        return "申请金额（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String detailPlanItemCode = calculateDto.getDetailPlanItemCode();
        Validate.notNull(detailPlanItemCode,"活动细案明细编码不能为空");
        Set<String> set = new HashSet<>(1);
        set.add(detailPlanItemCode);
        List<ActivityDetailPlanItemVo> byActivityDetailItemCodes = activityDetailPlanItemSdkService.findByActivityDetailItemCodes(set,null);
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        if (CollectionUtils.isEmpty(byActivityDetailItemCodes) || byActivityDetailItemCodes.size() == 0){
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(),byActivityDetailItemCodes.get(0).getFeeAmount());
        return resultMap;
    }
}
