package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 车补结案金额
 * @author hd
 */
@Service
@Slf4j
public class CarCompensationSettlementAmountRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private AuditCarSubsidyVoService auditCarSubsidyVoService;

    @Override
    public String getVariableCode() {
        return "carCompensationSettlementAmount";
    }

    @Override
    public String getVariableName() {
        return "车补结案金额（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String dealerCode = calculateDto.getDealerCode();
        Validate.notNull(dealerCode, "sap市场编码不能为空!");
        String yearMonthLy = calculateDto.getYearMonthLy();
        Validate.notNull(yearMonthLy, "年月不能为空!");
        try {
            DateUtil.date_yyyy_MM.parse(yearMonthLy);
        } catch (ParseException e) {
            log.error("", e);
            throw new RuntimeException("年月的格式应为【yyyy-MM】!");
        }
        AuditCarSubsidyDto carSubsidyDto = new AuditCarSubsidyDto();
        carSubsidyDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        carSubsidyDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        carSubsidyDto.setStatisticsMonth(yearMonthLy);
        carSubsidyDto.setSalesRegionCode(QueryConstant.SALES_REGION_CODE);
        carSubsidyDto.setDealerCode(dealerCode);
        // 渠道--没有对应渠道字段
        AuditCarSubsidyVo auditCarSubsidyVo = auditCarSubsidyVoService.findValueByConditions(carSubsidyDto);
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        if (ObjectUtils.isEmpty(auditCarSubsidyVo) || ObjectUtils.isEmpty(auditCarSubsidyVo.getMonthlyAmount())) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), auditCarSubsidyVo.getMonthlyAmount());
        return resultMap;
    }
}