package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmDailySalesDataService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 赠品金额
 */
@Service
@Slf4j
public class GiftAmtRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private TpmDailySalesDataService tpmDailySalesDataService;
    @Override
    public String getVariableCode() {
        return "giftAmt";
    }

    @Override
    public String getVariableName() {
        return "赠品金额（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getStartTimeOrDate(),"订单开始时间不能为空");
        Validate.notNull(calculateDto.getEndTimeOrDate(),"订单结束时间不能为空");
        Validate.notNull(calculateDto.getCustomerCode(),"客户编码不能为空");
        Validate.notNull(calculateDto.getProductCode(),"产品编码不能为空");
        String startTimeStr = DateUtil.dateToStr(calculateDto.getStartTimeOrDate(),new SimpleDateFormat("yyyy-MM-dd"));
        String endTimeStr = DateUtil.dateToStr(calculateDto.getEndTimeOrDate(),new SimpleDateFormat("yyyy-MM-dd"));
        TpmDailySalesDataDto tpmDailySalesDataDto = new TpmDailySalesDataDto();
        tpmDailySalesDataDto.setCustomerCode(calculateDto.getCustomerCode());
        tpmDailySalesDataDto.setMaterialCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        tpmDailySalesDataDto.setStartTimeStr(startTimeStr.replaceAll("-", ""));
        tpmDailySalesDataDto.setEndTimeStr(endTimeStr.replaceAll("-", ""));
        if(!StringUtils.isEmpty(calculateDto.getSalesOrgCode())){
            tpmDailySalesDataDto.setSalesInstitutionCode(calculateDto.getSalesOrgCode());
        }
        TpmDailySalesDataVo tpmDailySalesDataVo = tpmDailySalesDataService.findGift(tpmDailySalesDataDto);
        BigDecimal giftAmt = new BigDecimal(0);
        if(!Objects.isNull(tpmDailySalesDataVo)){
            giftAmt = tpmDailySalesDataVo.getGiftAmt();
        }
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(),giftAmt);
        return resultMap;
    }
}
