package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubCompanyExecuteIndicatorUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 人员打卡天数
 *
 * @author hd
 */
@Service
@Slf4j
public class PersonnelClockInRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SubCompanyExecuteIndicatorUtil subCompanyExecuteIndicatorUtil;

    @Override
    public String getVariableCode() {
        return "numberOfDaysPersonnelClockIn";
    }

    @Override
    public String getVariableName() {
        return "人员打卡天数（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

//    @Override
//    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        String customerCode = calculateDto.getCustomerCode();
//        Validate.notNull(customerCode,"客户编码不能为空!");
//        Validate.notNull(calculateDto.getYearMonthLy(),"活动时间不能为空");
//        AuditExecuteIndicatorDto auditExecuteIndicatorDto = new AuditExecuteIndicatorDto();
//        auditExecuteIndicatorDto.setCustomerCode(customerCode);
//        auditExecuteIndicatorDto.setYearAndMonth(DateUtil.strToDate(calculateDto.getYearMonthLy(),new SimpleDateFormat("yyyy-MM")));
//        auditExecuteIndicatorDto.setYearAndMonthStr(DateUtil.date_yyyyMMdd.format(auditExecuteIndicatorDto.getYearAndMonth()));
//        auditExecuteIndicatorDto.setVariableCode(this.getVariableCode());
//        List<AuditExecuteIndicatorVo> indicatorVoList = auditExecuteIndicatorService.findData(auditExecuteIndicatorDto);
//        BigDecimal indicatorValue = new BigDecimal(0);
//        if(CollectionUtils.isNotEmpty(indicatorVoList)){
//            BigDecimal indicatorValueTotal = new BigDecimal(0);
//            for (AuditExecuteIndicatorVo indicatorVo : indicatorVoList){
//                indicatorValueTotal = indicatorValueTotal.add(indicatorVo.getIndicatorValue());
//            }
//            indicatorValue = indicatorValueTotal.divide(BigDecimal.valueOf(indicatorVoList.size()),2,BigDecimal.ROUND_HALF_UP);
//        }
//        Map<String, BigDecimal> resultMap = new HashMap<>(1);
//        resultMap.put(this.getVariableCode(),indicatorValue);
//        return resultMap;
//    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), subCompanyExecuteIndicatorUtil.getValue(calculateDto, this.getVariableCode()));
        return resultMap;
    }
}