package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.tpm.business.red.pay.ledger.sdk.dto.MemberRedPacketDto;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.service.RedPayLedgerVoService;
import com.biz.crm.tpm.business.red.pay.ledger.sdk.vo.MemberRedPacketVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 红包兑付金额
 * @author hd
 */
@Service
@Slf4j
public class RedEnvelopePaymentAmountRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private RedPayLedgerVoService redPayLedgerVoService;

    @Override
    public String getVariableCode() {
        return "redEnvelopePaymentAmount";
    }

    @Override
    public String getVariableName() {
        return "红包兑付金额（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull(calculateDto.getActivitiesDetailCode(),"活动明细编码不能为空");
        MemberRedPacketDto memberRedPacketDto = new MemberRedPacketDto();
        memberRedPacketDto.setPlanItemCode(calculateDto.getActivitiesDetailCode());
        List<MemberRedPacketVo> memberRedPacketVos = redPayLedgerVoService.findByPlanItemCode(memberRedPacketDto);
        BigDecimal amount = new BigDecimal(0);
        if(CollectionUtils.isNotEmpty(memberRedPacketVos)){
            amount = memberRedPacketVos.stream().map(MemberRedPacketVo::getRedPacketAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO,BigDecimal::add);
        }
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(),amount);
        return resultMap;
    }
}
