package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.local.register.auditExecuteIndicator.common.AuditExecuteIndicatorParamBuilder;
import com.biz.crm.tpm.business.variable.local.register.subcompany.common.SubCompanyExecuteIndicatorUtil;
import com.biz.crm.tpm.business.variable.sdk.constant.QueryConstant;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 结案金额-主体
 *
 * @author hd
 */
@Service
@Slf4j
public class SettlementAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private SubCompanyExecuteIndicatorUtil subCompanyExecuteIndicatorUtil;

    @Override
    public String getVariableCode() {
        return "settlementAmount";
    }

    @Override
    public String getVariableName() {
        return "结案金额-主体";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    //    @Override
//    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
//        String customerCode = calculateDto.getCustomerCode();
//        Validate.notNull(customerCode, "客户编码不能为空!");
//        String salesOrgCode = calculateDto.getSalesOrgCode();
//        Validate.notNull(salesOrgCode, "销售组织编码不能为空!");
//        String yearMonthLy = calculateDto.getYearMonthLy();
//        Validate.notNull(yearMonthLy, "年月不能为空!");
//        AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
//        try {
//            indicatorDto.setYearAndMonth(DateUtil.date_yyyy_MM.parse(yearMonthLy));
//            indicatorDto.setYearAndMonthStr(DateUtil.date_yyyyMMdd.format(indicatorDto.getYearAndMonth()));
//        } catch (ParseException e) {
//            e.printStackTrace();
//            throw new RuntimeException("年月的格式应为【yyyy-MM】!");
//        }
//        indicatorDto.setCustomerCode(customerCode);
//        indicatorDto.setSalesOrgCode(salesOrgCode);
//        indicatorDto.setVariableCode(this.getVariableCode());
//        List<AuditExecuteIndicatorVo> indicatorVos = auditExecuteIndicatorService.findData(indicatorDto);
//        Map<String, BigDecimal> resultMap = new HashMap<>(1);
//        if (CollectionUtils.isEmpty(indicatorVos)) {
//            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
//            return resultMap;
//        }
//        resultMap.put(this.getVariableCode(), indicatorVos.get(0).getIndicatorValue());
//        return resultMap;
//    }
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), subCompanyExecuteIndicatorUtil.getValue(calculateDto, this.getVariableCode()));
        return resultMap;
    }
}
