package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * 主体活动申请金额
 * @author hd
 */
@Service
@Slf4j
public class SubjectActivityApplicationAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Override
    public String getVariableCode() {
        return "subjectActivityApplicationAmount";
    }

    @Override
    public String getVariableName() {
        return "主体活动申请金额";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String detailPlanItemCode = calculateDto.getDetailPlanItemCode();
        Validate.notNull(detailPlanItemCode,"活动细案明细编码不能为空!");
//        List<String> list = new ArrayList<>(1);
//        list.add(activitiesDetailCode);
        List<ActivityDetailPlanItemVo> vos = activityDetailPlanItemSdkService.findByActivityDetailItemCodes(Sets.newHashSet(detailPlanItemCode),null);
//        List<ActivityDetailPlanVo> byCodes = activityDetailPlanSdkService.findByCodes(list);
        Map<String,BigDecimal> resultMap = new HashMap<>(1);
        if(CollectionUtils.isEmpty(vos) || Objects.isNull(vos.get(0).getFeeAmount())){
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(),vos.get(0).getFeeAmount());
        return resultMap;
    }
}
