package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 全月全品销量（件）
 *
 * @author hd
 */
@Service
@Slf4j
public class TotalProductSalesRegister implements FormulaVariableRegister {
    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    @Override
    public String getVariableCode() {
        return "monthlySalesOfAllProducts";
    }

    @Override
    public String getVariableName() {
        return "全月全品销量（件）（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        validate(calculateDto);
        MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
        mainOnedaySalesDataDto.setCustomerCodeList(Lists.newArrayList(calculateDto.getCustomerCodeList()));
        mainOnedaySalesDataDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        mainOnedaySalesDataDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        mainOnedaySalesDataDto.setYearMonthLy(calculateDto.getYearMonthLy().replaceAll("-", ""));
        if (CollectionUtils.isEmpty(calculateDto.getCustomerCodeList())) {
            mainOnedaySalesDataDto.setSalesOrgCode(calculateDto.getSalesOrgCode());
        }
        List<MainOnedaySalesDataVo> salesDataVos = mainOnedaySaleDataService.listMainOnedaySalesData(mainOnedaySalesDataDto);
        BigDecimal minusSaleQuantity = new BigDecimal(0);
        if(CollectionUtils.isNotEmpty(salesDataVos)){
            for (MainOnedaySalesDataVo vo : salesDataVos){
                minusSaleQuantity = minusSaleQuantity.add(vo.getMinusSaleQuantity());
            }
        }
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        resultMap.put(this.getVariableCode(),minusSaleQuantity);
        return resultMap;
    }

    /**
     * 条件验证
     * @param calculateDto
     */
    private void validate(CalculateDto calculateDto){
//        Validate.notNull(calculateDto.getCustomerCode(),"客户编码不能为空");
        /*Validate.notNull(calculateDto.getBusinessFormatCode(),"业态不能为空");
        Validate.notNull(calculateDto.getBusinessUnitCode(),"业务单元不能为空");
        Validate.notNull(calculateDto.getSalesOrgCode(),"销售组织不能为空");*/
        Validate.notNull(calculateDto.getYearMonthLy(),"活动年月不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(calculateDto.getSalesOrgCode()) || CollectionUtils.isNotEmpty(calculateDto.getCustomerCodeList()),
                "[全月全品销量（件）] 销售组织编码和客户编码不能同时为空！");

    }
}
