package com.biz.crm.tpm.business.variable.local.register.auditSubjectIndex;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 方案申请金额
 */
@Service
@Slf4j
public class VerticalSchemeApplyAmountRegister implements FormulaVariableRegister {

    @Autowired(required = false)
    private ActivityPlanItemService activityPlanItemService;

    @Override
    public String getVariableCode() {
        return "verticalSchemeApplyAmount";
    }

    @Override
    public String getVariableName() {
        return "方案申请金额（垂直）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String planItemCode = calculateDto.getPlanItemCode();
        Validate.notNull(planItemCode,"活动方案明细编码不能为空");
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        dto.setPlanItemCode(planItemCode);
        ActivityPlanItemBase planItemBase = activityPlanItemService.applyAmountFindByItemCode(dto);
        Map<String, BigDecimal> resultMap = new HashMap<>(1);
        BigDecimal amount = BigDecimal.ZERO;
        if (planItemBase != null){
            amount = planItemBase.getFeeAmount();
        }
        resultMap.put(this.getVariableCode(),amount);
        return resultMap;
    }
}
