package com.biz.crm.tpm.business.variable.local.register.budget;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.ControlsDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 销售进度
 */
@Service
@Slf4j
public class VariableP0003Register implements FormulaVariableRegister {


    /**
     * 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.BUDGET);
        return functionList;
    }

    @Override
    public String getVariableCode() {
        return "P0003";
    }

    @Override
    public String getVariableName() {
        return "年度销售进度";
    }

    @Override
    public Integer getSort() {
        return 4;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>(4);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        return resultMap;
    }

}
