package com.biz.crm.tpm.business.variable.local.register.budget;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetDepartmentBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.variable.local.register.budget.helper.HeadMonthBudgetVariableHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.VariableSelectBudgetDto;
import com.biz.crm.tpm.business.variable.sdk.enums.QuarterEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description:大区行销费用-费用进度-Q1
 * @Author qiancheng
 * @Date 2023/8/22
 */
@Slf4j
@Service
public class VariableP0005Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private HeadMonthBudgetVariableHelper headMonthBudgetVariableHelper;

    @Override
    public String getVariableCode() {
        return "P0005";
    }

    @Override
    public String getVariableName() {
        return "大区行销费用-费用进度-Q1";
    }

    @Override
    public Integer getSort() {
        return 6;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.BUDGET);
        return functionList;
    }

    /**
     *
     * @param calculateDto 计算条件
     * @return Map <key>预算项目编码</key><value>指标值</value>
     */
    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notBlank(calculateDto.getOrgCode(),"部门不能为空！");
        Validate.notBlank(calculateDto.getYearMonthLy(),"年月不能为空！");
        Map<String,BigDecimal> resultMap = new HashMap<>();

        VariableSelectBudgetDto dto = new VariableSelectBudgetDto();
        dto.setQuarter(QuarterEnum.Q1.getCode());
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
        dto.setDepartmentBelongCode(BudgetDepartmentBelongEnum.MARKET.getCode());
        dto.setOrgCode(calculateDto.getOrgCode());
        dto.setBudgetItemCode(calculateDto.getBudgetItemCode());
        dto.setOrgCode(calculateDto.getOrgCode());
        dto.setYearMonthLy(calculateDto.getYearMonthLy());
        //1.按业态、业务单元、归口、部门归口维度查预算项目编码
        List<String> budgetItemCodes = headMonthBudgetVariableHelper.calculateVariable(dto);
        Validate.notEmpty(budgetItemCodes,"未找到预算项目！指标["+this.getVariableName()+"}");
        //2.按部门+年月(1季度)+预算项目为维度，汇总1季度的结案金额(结案金额没有值的取批复金额)，除以1季度的年初分解金额之和
        dto.setBudgetItemCodes(budgetItemCodes);
            //按部门+年月(1季度)+预算项目为维度，汇总1季度的结案金额,批复金额,年度分解金额 // key : 预算项目编码  value:季度各金额汇总
        Map<String, MonthBudgetVo> monthBudgetForVariableMap = headMonthBudgetVariableHelper.findMonthBudgetRegionMarketingCost(dto);
        Validate.notEmpty(monthBudgetForVariableMap,"未找到月度预算数据！指标["+this.getVariableName()+"}");

        //4.计算对应预算项目的指标值
        monthBudgetForVariableMap.forEach((k,v) -> {
            BigDecimal resultValue = BigDecimal.ZERO;

            //按季度汇总的结案金额或批复金额
            BigDecimal numerator = BigDecimal.ZERO;
            if (!Objects.isNull(v.getAuditAmount())){
                numerator = v.getAuditAmount();
            }else if (!Objects.isNull(v.getApprovedAmount())) {
                numerator = v.getApprovedAmount();
            }
            //按季度汇总的年初分解金额
            BigDecimal denominator = Optional.ofNullable(v.getInitResolveAmount()).orElse(BigDecimal.ZERO);
            log.info("大区行销费用-费用进度-Q1,预算项目["+k+"],结案金额或批复金额:{},年初分解金额:{}",numerator,denominator);
            if (BigDecimal.ZERO.compareTo(denominator) == 0) {
                resultMap.put(k,BigDecimal.ZERO);
            }else {
                resultValue = numerator.divide(denominator,6,BigDecimal.ROUND_HALF_UP);
                resultMap.put(k,resultValue);
            }
        });

        return resultMap;
    }
}
