package com.biz.crm.tpm.business.variable.local.register.budget;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.BudgetDepartmentBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.variable.local.register.budget.helper.HeadMonthBudgetVariableHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.VariableSelectBudgetDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Description:大区销售常规-费用进度-销量进度-累计月度
 * @Author qiancheng
 * @Date 2023/6/13
 */
@Slf4j
@Service
public class VariableP0009Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private HeadMonthBudgetVariableHelper headMonthBudgetVariableHelper;

    @Override
    public String getVariableCode() {
        return "P0009";
    }

    @Override
    public String getVariableName() {
        return "大区销售常规-费用进度-销量进度-累计月度";
    }

    @Override
    public Integer getSort() {
        return 10;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.BUDGET);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Map<String,BigDecimal> resultMap = new HashMap<>();

        VariableSelectBudgetDto dto = new VariableSelectBudgetDto();
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        dto.setFeeBelongCode(FeeBelongEnum.AREA.getCode());
        dto.setDepartmentBelongCode(BudgetDepartmentBelongEnum.SALE_MANAGE.getCode());
        dto.setBudgetItemCode(calculateDto.getBudgetItemCode());
        //1.按业态、业务单元、归口、部门归口、归类维度查预算项目编码
        List<String> budgetItemCodes = headMonthBudgetVariableHelper.calculateVariable(dto);
        Validate.notEmpty(budgetItemCodes,"未找到预算项目！指标["+this.getVariableName()+"]");
        //2.在1的基础上查询月度预算
        dto.setBudgetItemCodes(budgetItemCodes);
        List<MonthBudgetVo> monthBudgetVoList = headMonthBudgetVariableHelper.findMonthBudgetConditionForVariable(dto);
        Validate.notEmpty(monthBudgetVoList,"未找到,计算指标["+this.getVariableName()+"],所需要的月度预算数据！");

        //3 按预算项目编码分组
        Map<String, List<MonthBudgetVo>> monthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.groupingBy(MonthBudgetVo::getBudgetItemCode));
        monthBudgetVoMap.forEach((k,v) -> {
            //分子
            BigDecimal minuend = BigDecimal.ZERO;

            //结案金额或批复金额总计
            BigDecimal auditAmount = BigDecimal.ZERO;
            //年初分解金额总计
            BigDecimal initResolveAmount = v.stream().map(MonthBudgetVo::getInitResolveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(initResolveAmount) != 0) {

                auditAmount = v.stream().map(MonthBudgetVo::getAuditAmount).reduce(BigDecimal.ZERO, BigDecimal::add);

                if (BigDecimal.ZERO.compareTo(auditAmount) == 0) {
                    auditAmount = v.stream().map(MonthBudgetVo::getApprovedAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }

                minuend = auditAmount.divide(initResolveAmount,6,BigDecimal.ROUND_HALF_UP);
            }

            //分母  实际销售金额 / 实际销量预算（实销金额字段）总计
            BigDecimal subtrahend = BigDecimal.ZERO;
            for (MonthBudgetVo monthBudgetVo : v) {
                //实际销量预算
                BigDecimal actualSales = Optional.ofNullable(monthBudgetVo.getActualSales()).orElse(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(actualSales) == 0) {
                    continue;
                }
                //预算点数
                BigDecimal budgetTotalPoint = Optional.ofNullable(monthBudgetVo.getBudgetTotalPoint()).orElse(BigDecimal.ZERO);
                subtrahend.add(actualSales.multiply(budgetTotalPoint).divide(actualSales,6,BigDecimal.ROUND_HALF_UP));
            }
            log.info("大区销售常规-费用进度-销量进度-累计月度,预算项目["+k+"],结案金额或批复金额:{},年初分解金额:{},实际销售金额/实际销量预算（实销金额）总计:{}",auditAmount,initResolveAmount,subtrahend);

            resultMap.put(k,minuend.subtract(subtrahend));

        });

        return resultMap;
    }
}
