package com.biz.crm.tpm.business.variable.local.register.budget;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:销售品类涨价大区-250-费用节奏-销量节奏-月度&全年
 * @Author qiancheng
 * @Date 2023/8/24
 */
@Slf4j
@Service
public class VariableP0013Register implements FormulaVariableRegister {
    @Override
    public String getVariableCode() {
        return "P0013";
    }

    @Override
    public String getVariableName() {
        return "销售品类涨价大区-250-费用节奏-销量节奏-月度&全年";
    }

    @Override
    public Integer getSort() {
        return 14;
    }

    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.BUDGET);
        return functionList;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        HashMap<String, BigDecimal> resultMap = new HashMap<>();
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        return resultMap;
    }
}
