package com.biz.crm.tpm.business.variable.local.register.budget.helper;

import com.alibaba.excel.util.StringUtils;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemControlConditionVoService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.variable.sdk.dto.VariableSelectBudgetDto;
import com.biz.crm.tpm.business.variable.sdk.enums.QuarterEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description:主体预算指标助手
 * @Author qiancheng
 * @Date 2023/8/22
 */
@Component
@Slf4j
public class HeadMonthBudgetVariableHelper {

    @Autowired(required = false)
    private BudgetItemControlConditionVoService budgetItemControlConditionVoService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    public List<String> calculateVariable(VariableSelectBudgetDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(),"业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(),"业务单元不能为空!");
        Validate.notBlank(dto.getFeeBelongCode(),"费用归口不能为空！");
        Validate.notBlank(dto.getDepartmentBelongCode(),"部门归口不能为空！");
        //按业态、业务单元、归口、部门归口维度查预算项目编码
        BudgetItemControlConditionDto conditionDto = new BudgetItemControlConditionDto();
        conditionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        conditionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        conditionDto.setFeeBelongCode(dto.getFeeBelongCode());
        conditionDto.setDepartmentBelongCode(dto.getDepartmentBelongCode());
        conditionDto.setBudgetItemCode(dto.getBudgetItemCode());
        log.info("预算整体管控查询预算项目,参数:{}", JSON.toJSONString(conditionDto));
        List<String> budgetItemCodes = budgetItemControlConditionVoService.findCodeForVariable(conditionDto);
        log.info("预算整体管控查询预算项目,budgetItemCodes.size:{}", budgetItemCodes.size());
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return Lists.newArrayList();
        }
        return budgetItemCodes;
    }

    public Map<String,MonthBudgetVo> findMonthBudgetRegionMarketingCost(VariableSelectBudgetDto dto){
        Validate.notBlank(dto.getBusinessFormatCode(),"业态不能为空!");
        Validate.notBlank(dto.getBusinessUnitCode(),"业务单元不能为空!");
        Validate.notBlank(dto.getFeeBelongCode(),"费用归口不能为空!");
        Validate.notBlank(dto.getOrgCode(),"部门不能为空！");
        Validate.notBlank(dto.getYearMonthLy(),"年月不能为空！");
        Validate.notEmpty(dto.getBudgetItemCodes(),"预算项目编码不能为空！");
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        monthBudgetDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        monthBudgetDto.setFeeBelongCode(dto.getFeeBelongCode());
        monthBudgetDto.setOrgCode(dto.getOrgCode());
        monthBudgetDto.setBudgetItemCodeList(dto.getBudgetItemCodes());
        String year = dto.getYearMonthLy().substring(0,4);
        List<String> yearMonthList = new ArrayList<>();
        if (QuarterEnum.Q1.getCode().equals(dto.getQuarter())) {
            yearMonthList.add(year + "-" + "01");
            yearMonthList.add(year + "-" + "02");
            yearMonthList.add(year + "-" + "03");
        }
        if (QuarterEnum.Q2.getCode().equals(dto.getQuarter())) {
            yearMonthList.add(year + "-" + "04");
            yearMonthList.add(year + "-" + "05");
            yearMonthList.add(year + "-" + "06");
        }
        if (QuarterEnum.Q3.getCode().equals(dto.getQuarter())) {
            yearMonthList.add(year + "-" + "07");
            yearMonthList.add(year + "-" + "08");
            yearMonthList.add(year + "-" + "09");
        }
        if (StringUtils.isBlank(dto.getQuarter())) {
            monthBudgetDto.setYearMonthLy(dto.getYearMonthLy());
        }else {
            monthBudgetDto.setYearMonthLyList(yearMonthList);
        }
        log.info("预算整体管控查询月度预算,参数:{}", JSON.toJSONString(monthBudgetDto));
        List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.findMonthBudgetForVariable(monthBudgetDto);
        log.info("预算整体管控查询月度预算,monthBudgetVoList.size:{}", monthBudgetVoList.size());
        if (CollectionUtils.isEmpty(monthBudgetVoList)) {
            return Maps.newHashMap();
        }
        Map<String, MonthBudgetVo> map = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getBudgetItemCode, Function.identity()));
        return map;
    }

    public List<MonthBudgetVo> findMonthBudgetConditionForVariable(VariableSelectBudgetDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(),"业态不能为空!");
        Validate.notBlank(dto.getBusinessUnitCode(),"业务单元不能为空!");
        Validate.notBlank(dto.getFeeBelongCode(),"费用归口不能为空!");
        Validate.notEmpty(dto.getBudgetItemCodes(),"预算项目编码不能为空！");
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        monthBudgetDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        monthBudgetDto.setFeeBelongCode(dto.getFeeBelongCode());
        monthBudgetDto.setBudgetItemCodeList(dto.getBudgetItemCodes());
        log.info("预算整体管控查询月度预算,参数:{}", JSON.toJSONString(monthBudgetDto));
        List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.findMonthBudgetConditionForVariable(monthBudgetDto);
        log.info("预算整体管控查询月度预算,monthBudgetVoList.size:{}", monthBudgetVoList.size());
        if (CollectionUtils.isEmpty(monthBudgetVoList)) {
            return Lists.newArrayList();
        }
        return monthBudgetVoList;
    }

}
