package com.biz.crm.tpm.business.variable.local.register.common;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 变量-询价参数组装
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-28
 */
@Slf4j
public class PriceRegisterParamBuilder {

    public static SearchPriceDto buildParam(CalculateDto calculateDto, PriceTypeEnum priceTypeEnum) {
        SearchPriceDto searchPrice = new SearchPriceDto();
        searchPrice.setPriceTypeCode(priceTypeEnum.getDictCode());
        searchPrice.setDimensionItems(PriceRegisterParamBuilder.buildDimensionItems(calculateDto));
        searchPrice.setSearchTime(calculateDto.getSearchTime());
        log.info("指标询价参数=====》{}", JSONObject.toJSONString(searchPrice));
        return searchPrice;
    }

    //维度
    public static List<SearchPriceDimensionItemDto> buildDimensionItems(CalculateDto calculateDto) {
        List<SearchPriceDimensionItemDto> itemDtos = new ArrayList<>();
        buildDimensionItem(PriceDimensionEnum.CHANNEL, calculateDto.getChannel(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.MATERIAL, calculateDto.getProductCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.PRODUCT_GROUP, calculateDto.getBusinessFormatCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.CUSTOMER, calculateDto.getCustomerErpCode(), itemDtos);
//        buildDimensionItem(PriceDimensionEnum.TERMINAL, calculateDto.getTerminalCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.SALES_ORG_CODE, calculateDto.getSalesOrgErpCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.SALES_INSTITUTION_CODE, calculateDto.getSalesOrganizationErpCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.SALES_GROUP, calculateDto.getSalesGroupErpCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.ORG_CODE, calculateDto.getBusinessFormatCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.DISTRIBUTION_CHANNEL, calculateDto.getDistributionChannel(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.SELLER_CODE, calculateDto.getCustomerErpCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.DELIVERY_CODE, calculateDto.getStoresCode(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.SALE_REGION, calculateDto.getSaleRegion(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.PRICE_AREA, calculateDto.getPriceArea(), itemDtos);
        buildDimensionItem(PriceDimensionEnum.SALE_UNIT, "PC", itemDtos);
        return itemDtos;
    }

    public static void buildDimensionItem(PriceDimensionEnum dimensionEnum, String value, List<SearchPriceDimensionItemDto> itemDtos) {
        if (StringUtils.isNotEmpty(value)) {
            SearchPriceDimensionItemDto dimensionItemDto = new SearchPriceDimensionItemDto();
            dimensionItemDto.setDimensionCode(dimensionEnum.getDictCode());
            dimensionItemDto.setRelateCodeSet(Sets.newHashSet(value));
            itemDtos.add(dimensionItemDto);
        }
    }
}
