package com.biz.crm.tpm.business.variable.local.register.common;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-03
 */
public class VariableDateParamBuilder {

    /**
     * 电商：如果当前月为1月，取上一年度的所有数据，否则，取当前年度的1月到上一个月的所有数据
     *
     * @param yearMonthStr
     * @return
     */
    public List<String> esYearMonthStrList(String yearMonthStr) {
        List<String> list = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(yearMonthStr, DateUtil.DEFAULT_YEAR_MONTH));
        int month = calendar.get(Calendar.MONTH) + 1;
        if (month == 1) {
            calendar.add(Calendar.YEAR, -1);
            int year = calendar.get(Calendar.YEAR);
            while (month <= 12) {
                list.add(year + "-" + fullMonthStr(month));
                month++;
            }
            return list;
        }
        month--;
        int year = calendar.get(Calendar.YEAR);
        while (month > 0) {
            list.add(year + "-" + fullMonthStr(month));
            month--;
        }
        return list;
    }

    public String fullMonthStr(int month) {
        if (Integer.valueOf(month).toString().length() == 1) {
            return "0" + month;
        } else {
            return Integer.valueOf(month).toString();
        }
    }
}
