package com.biz.crm.tpm.business.variable.local.register.common;

import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-13
 */
@Service
public class VariableProductLevelService {
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;

    /**
     * 查询产品层级，按层级分组返回编码
     *
     * @param vo
     * @return
     */
    public Map<String, List<String>> levelCodeMap(ProductLevelVo vo) {
        List<ProductLevelVo> levelVos = this.levelList(vo);
        return levelVos.stream()
                .filter(e -> Objects.nonNull(e.getProductLevelType()))
                .collect(Collectors.groupingBy(e -> e.getProductLevelType().getCode(),
                        Collectors.mapping(ProductLevelVo::getProductLevelCode, Collectors.toList())));
    }

    public List<ProductLevelVo> levelList(ProductLevelVo vo) {
        List<ProductLevelVo> list = productLevelVoSdkService.findListByParams(vo);
        if (!CollectionUtils.isEmpty(list)) {
            return list;
        }
        return Lists.newArrayList();
    }
}
