package com.biz.crm.tpm.business.variable.local.register.common;

import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-23
 */
@Slf4j
public class VariablePropertyValueHelper {

    @SneakyThrows
    public static BigDecimal getValue(Class<?> clazz, String propertyName, Object object) {
        if (Objects.isNull(clazz) || StringUtils.isEmpty(propertyName) || Objects.isNull(object)) {
            throw new RuntimeException("缺少必要参数！");
        }
        Field filed = clazz.getDeclaredField(propertyName);
        filed.setAccessible(true);
        Object o = filed.get(object);
        if (Objects.isNull(o)) {
            return BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            return new BigDecimal(o.toString());
        } else if (o instanceof Integer) {
            return BigDecimal.valueOf(Integer.parseInt(o.toString()));
        } else if (o instanceof Float) {
            return BigDecimal.valueOf(Float.parseFloat(o.toString()));
        } else if (o instanceof Double) {
            return BigDecimal.valueOf(Double.parseDouble(o.toString()));
        } else if (o instanceof String) {
            try {
                return new BigDecimal(o.toString());
            } catch (Exception e) {
                throw new RuntimeException("值[" + o + "]字段类型转换异常：" + e.getMessage(), e);
            }
        }
        return BigDecimal.ZERO;
    }
}
