package com.biz.crm.tpm.business.variable.local.register.configure;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.register.configure.common.ConVariableRegisterParamHandler;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * 费用进度
 */
@Service
@Slf4j
public class ConVariableC0001Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private ConVariableRegisterParamHandler conVariableRegisterParamHandler;

    /**
     * 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Boolean isConfigurable() {
        return true;
    }

    @Override
    public String getVariableCode() {
        return "conVariableC0001";
    }

    @Override
    public String getVariableName() {
        return "全品全月销售量（不含2C奶卡）剔量（主体）";
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List<MainOnedaySalesDataVo> data = conVariableRegisterParamHandler.findExcludeData(calculateDto, this.getVariableCode());
        HashMap<String, BigDecimal> resultMap = new HashMap<>(4);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(data)) {
            return resultMap;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (MainOnedaySalesDataVo dataVo : data) {
            if (Objects.nonNull(dataVo.getMinusDiscountBehindTaxSaleAmount())) {
                total = total.add(dataVo.getMinusDiscountBehindTaxSaleAmount());
            }
            if (Objects.nonNull(dataVo.getMinusMilkCardDiscountBehindOrderAmountToB())) {
                total = total.add(dataVo.getMinusMilkCardDiscountBehindOrderAmountToB());
            }
        }
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}
