package com.biz.crm.tpm.business.variable.local.register.configure;

import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.variable.local.register.configure.common.ConVariableRegisterParamHandler;
import com.biz.crm.tpm.business.variable.local.repository.ConVariableDetailRepository;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 费用进度
 */
@Service
@Slf4j
public class ConVariableC0002Register implements FormulaVariableRegister {

    @Autowired(required = false)
    private ConVariableRegisterParamHandler conVariableRegisterParamHandler;

    /**
     * 适用范围
     */
    @Override
    public List<VariableFunctionEnum> getFunctionEnumList() {
        List<VariableFunctionEnum> functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    @Override
    public Boolean isConfigurable() {
        return true;
    }

    @Override
    public String getVariableCode() {
        return "conVariableC0002";
    }

    @Override
    public String getVariableName() {
        return "全品全月销售量（含奶卡）剔量（主体）";
    }

    @Override
    public Integer getSort() {
        return 2;
    }

    @Override
    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        List<MainOnedaySalesDataVo> data = conVariableRegisterParamHandler.findExcludeData(calculateDto, this.getVariableCode());
        HashMap<String, BigDecimal> resultMap = new HashMap<>(4);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (CollectionUtils.isEmpty(data)) {
            return resultMap;
        }
        BigDecimal total = data.stream()
                .filter(e -> Objects.nonNull(e.getMinusDiscountBehindTaxSaleAmountIn()))
                .map(MainOnedaySalesDataVo::getMinusDiscountBehindTaxSaleAmountIn)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        resultMap.put(this.getVariableCode(), total);
        return resultMap;
    }
}
